/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.particle;

import com.lightning.northstar.particle.NorthstarParticles;
import com.lightning.northstar.particle.SnowflakeParticle;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SnowflakeParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<SnowflakeParticleData> {
    public static final Codec<SnowflakeParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("x").forGetter(p -> p.posX), (App)Codec.INT.fieldOf("y").forGetter(p -> p.posY), (App)Codec.INT.fieldOf("z").forGetter(p -> p.posZ)).apply((Applicative)i, SnowflakeParticleData::new));
    public static final ParticleOptions.Deserializer<SnowflakeParticleData> DESERIALIZER = new ParticleOptions.Deserializer<SnowflakeParticleData>(){

        public SnowflakeParticleData fromCommand(ParticleType<SnowflakeParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int x = reader.readInt();
            reader.expect(' ');
            int y = reader.readInt();
            reader.expect(' ');
            int z = reader.readInt();
            return new SnowflakeParticleData(x, y, z);
        }

        public SnowflakeParticleData fromNetwork(ParticleType<SnowflakeParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new SnowflakeParticleData(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
    };
    final int posX;
    final int posY;
    final int posZ;

    public SnowflakeParticleData(Vec3i pos) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public SnowflakeParticleData(int posX, int posY, int posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public SnowflakeParticleData() {
        this(0, 0, 0);
    }

    public ParticleType<?> m_6012_() {
        return NorthstarParticles.SNOWFLAKE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.posX);
        buffer.writeInt(this.posY);
        buffer.writeInt(this.posZ);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d %d", NorthstarParticles.SNOWFLAKE.parameter(), this.posX, this.posY, this.posZ);
    }

    public ParticleOptions.Deserializer<SnowflakeParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    public Codec<SnowflakeParticleData> getCodec(ParticleType<SnowflakeParticleData> type) {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleEngine.SpriteParticleRegistration<SnowflakeParticleData> getMetaFactory() {
        return SnowflakeParticle.Factory::new;
    }
}

