/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.particle;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.depot.EjectorBlock;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.content.logistics.depot.EjectorTargetHandler;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SpawnParticlePacket
extends SimplePacketBase {
    private int h;
    private int v;
    private BlockPos pos;
    private Direction facing;

    public SpawnParticlePacket(int h, int v, BlockPos pos, Direction facing) {
        this.h = h;
        this.v = v;
        this.pos = pos;
        this.facing = facing;
    }

    public SpawnParticlePacket(FriendlyByteBuf buffer) {
        this.h = buffer.readInt();
        this.v = buffer.readInt();
        this.pos = buffer.m_130135_();
        this.facing = Direction.m_122376_((int)buffer.m_130242_());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.h);
        buffer.writeInt(this.v);
        buffer.m_130064_(this.pos);
        buffer.m_130130_(this.facing.m_122411_());
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level world = player.m_9236_();
            if (world == null || !world.m_46749_(this.pos)) {
                return;
            }
            BlockEntity blockEntity = world.m_7702_(this.pos);
            BlockState state = world.m_8055_(this.pos);
            if (blockEntity instanceof EjectorBlockEntity) {
                ((EjectorBlockEntity)blockEntity).setTarget(this.h, this.v);
            }
            if (AllBlocks.WEIGHTED_EJECTOR.has(state)) {
                world.m_46597_(this.pos, (BlockState)state.m_61124_(EjectorBlock.HORIZONTAL_FACING, (Comparable)this.facing));
            }
        });
        return true;
    }

    public static class ClientBoundRequest
    extends SimplePacketBase {
        BlockPos pos;

        public ClientBoundRequest(BlockPos pos) {
            this.pos = pos;
        }

        public ClientBoundRequest(FriendlyByteBuf buffer) {
            this.pos = buffer.m_130135_();
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130064_(this.pos);
        }

        public boolean handle(NetworkEvent.Context context) {
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> EjectorTargetHandler.flushSettings((BlockPos)this.pos)));
            return true;
        }
    }
}

