/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features;

import com.lightning.northstar.world.features.configuration.StoneClusterConfiguration;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StoneClusterFeature
extends Feature<StoneClusterConfiguration> {
    public StoneClusterFeature(Codec<StoneClusterConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<StoneClusterConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        BlockPos blockpos = pContext.m_159777_();
        StoneClusterConfiguration config = (StoneClusterConfiguration)pContext.m_159778_();
        RandomSource randomsource = pContext.m_225041_();
        int i = config.height().m_214085_(randomsource);
        float f = config.wetness().m_214084_(randomsource);
        float f1 = config.density().m_214084_(randomsource);
        int j = config.radius().m_214085_(randomsource);
        int k = config.radius().m_214085_(randomsource);
        float lavaness = config.lavaness().m_214084_(randomsource);
        float thirdthingness = config.thirdthingness().m_214084_(randomsource);
        for (int l = -j; l <= j; ++l) {
            for (int i1 = -k; i1 <= k; ++i1) {
                double d0 = this.getChanceOfStalagmiteOrStalactite(j, k, l, i1, config);
                BlockPos blockpos1 = blockpos.m_7918_(l, 0, i1);
                this.placeColumn(worldgenlevel, randomsource, blockpos1, l, i1, f, lavaness, thirdthingness, d0, i, f1, config);
            }
        }
        return true;
    }

    private void placeColumn(WorldGenLevel pLevel, RandomSource pRandom, BlockPos pPos, int pX, int pZ, float pWetness, float lavaness, float thirdthingness, double pChance, int pHeight, float pDensity, StoneClusterConfiguration config) {
        Optional optional = Column.m_158175_((LevelSimulatedReader)pLevel, (BlockPos)pPos, (int)config.floorToCeilingSearchRange(), block -> !block.m_60804_((BlockGetter)pLevel, pPos), blockdeny -> blockdeny.m_60804_((BlockGetter)pLevel, pPos));
        if (optional.isPresent()) {
            OptionalInt optionalint = ((Column)optional.get()).m_142011_();
            OptionalInt optionalint1 = ((Column)optional.get()).m_142009_();
            if (optionalint.isPresent() || optionalint1.isPresent()) {
                boolean flag3;
                int j1;
                int j3;
                int i3;
                boolean flag2;
                int j;
                boolean flag1;
                Column column;
                int i;
                boolean thirdthing_flag;
                boolean water_flag = pRandom.m_188501_() < pWetness;
                boolean lava_flag = pRandom.m_188501_() < lavaness;
                boolean bl = thirdthing_flag = pRandom.m_188501_() < thirdthingness;
                if (water_flag && optionalint1.isPresent()) {
                    i = optionalint1.getAsInt();
                    column = ((Column)optional.get()).m_158181_(OptionalInt.of(i - 1));
                    pLevel.m_7731_(pPos.m_175288_(i), Blocks.f_49990_.m_49966_(), 2);
                    this.m_159739_(pLevel, pPos.m_175288_(i).m_7495_());
                } else {
                    column = (Column)optional.get();
                }
                if (lava_flag && optionalint1.isPresent() && optionalint.isPresent()) {
                    i = optionalint1.getAsInt();
                    column = ((Column)optional.get()).m_158181_(OptionalInt.of(i - 1));
                    pLevel.m_7731_(pPos.m_175288_(i), Blocks.f_49991_.m_49966_(), 2);
                    this.m_159739_(pLevel, pPos.m_175288_(i).m_7495_());
                }
                if (thirdthing_flag && optionalint1.isPresent()) {
                    i = optionalint1.getAsInt();
                    column = ((Column)optional.get()).m_158181_(OptionalInt.of(i - 1));
                    pLevel.m_7731_(pPos.m_175288_(i), config.fluid_provider().m_76188_(), 2);
                    this.m_159739_(pLevel, pPos.m_175288_(i).m_7495_());
                }
                OptionalInt optionalint2 = column.m_142009_();
                boolean bl2 = flag1 = pRandom.m_188500_() < pChance;
                if (optionalint.isPresent() && flag1 && !this.isLava((LevelReader)pLevel, pPos.m_175288_(optionalint.getAsInt()))) {
                    int k = config.dripstoneBlockLayerThickness().m_214085_(pRandom);
                    this.replaceBlocksWithStoneBlocks(pLevel, pPos.m_175288_(optionalint.getAsInt()), k, Direction.UP);
                    int l = optionalint2.isPresent() ? Math.min(pHeight, optionalint.getAsInt() - optionalint2.getAsInt()) : pHeight;
                    j = this.getStoneHeight(pRandom, pX, pZ, pDensity, l, config);
                } else {
                    j = 0;
                }
                boolean bl3 = flag2 = pRandom.m_188500_() < pChance;
                if (optionalint2.isPresent() && flag2 && !this.isLava((LevelReader)pLevel, pPos.m_175288_(optionalint2.getAsInt()))) {
                    int i1 = config.dripstoneBlockLayerThickness().m_214085_(pRandom);
                    this.replaceBlocksWithStoneBlocks(pLevel, pPos.m_175288_(optionalint2.getAsInt()), i1, Direction.DOWN);
                    i3 = optionalint.isPresent() ? Math.max(0, j + Mth.m_216287_((RandomSource)pRandom, (int)(-config.maxStalagmiteStalactiteHeightDiff()), (int)config.maxStalagmiteStalactiteHeightDiff())) : this.getStoneHeight(pRandom, pX, pZ, pDensity, pHeight, config);
                } else {
                    i3 = 0;
                }
                if (optionalint.isPresent() && optionalint2.isPresent() && optionalint.getAsInt() - j <= optionalint2.getAsInt() + i3) {
                    int k1 = optionalint2.getAsInt();
                    int l1 = optionalint.getAsInt();
                    int i2 = Math.max(l1 - j, k1 + 1);
                    int j2 = Math.min(k1 + i3, l1 - 1);
                    int k2 = Mth.m_216287_((RandomSource)pRandom, (int)i2, (int)(j2 + 1));
                    int l2 = k2 - 1;
                    j3 = l1 - k2;
                    j1 = l2 - k1;
                } else {
                    j3 = j;
                    j1 = i3;
                }
                boolean bl4 = flag3 = pRandom.m_188499_() && j3 > 0 && j1 > 0 && column.m_142030_().isPresent() && j3 + j1 == column.m_142030_().getAsInt();
                if (optionalint.isPresent()) {
                    StoneClusterFeature.growPointyStone((LevelAccessor)pLevel, pPos.m_175288_(optionalint.getAsInt() - 1), Direction.DOWN, j3, flag3, config);
                }
                if (optionalint2.isPresent()) {
                    StoneClusterFeature.growPointyStone((LevelAccessor)pLevel, pPos.m_175288_(optionalint2.getAsInt() + 1), Direction.UP, j1, flag3, config);
                }
            }
        }
    }

    private void replaceBlocksWithStoneBlocks(WorldGenLevel pLevel, BlockPos pPos, int pThickness, Direction pDirection) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        for (int i = 0; i < pThickness; ++i) {
            blockpos$mutableblockpos.m_122173_(pDirection);
        }
    }

    private double getChanceOfStalagmiteOrStalactite(int pXRadius, int pZRadius, int pX, int pZ, StoneClusterConfiguration config) {
        int i = pXRadius - Math.abs(pX);
        int j = pZRadius - Math.abs(pZ);
        int k = Math.min(i, j);
        return Mth.m_184631_((float)k, (float)0.0f, (float)config.maxDistanceFromEdgeAffectingChanceOfDripstoneColumn(), (float)config.chanceOfDripstoneColumnAtMaxDistanceFromCenter(), (float)1.0f);
    }

    private int getStoneHeight(RandomSource pRandom, int pX, int pZ, float pChance, int pHeight, StoneClusterConfiguration config) {
        if (pRandom.m_188501_() > pChance) {
            return 0;
        }
        int i = Math.abs(pX) + Math.abs(pZ);
        float f = (float)Mth.m_144851_((double)i, (double)0.0, (double)config.maxDistanceFromCenterAffectingHeightBias(), (double)((double)pHeight / 2.0), (double)0.0);
        return (int)StoneClusterFeature.randomBetweenBiased(pRandom, 0.0f, pHeight, f, config.heightDeviation());
    }

    private static float randomBetweenBiased(RandomSource pRandom, float pMin, float pMax, float pMean, float pDeviation) {
        return ClampedNormalFloat.m_216837_((RandomSource)pRandom, (float)pMean, (float)pDeviation, (float)pMin, (float)pMax);
    }

    private boolean isLava(LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos).m_60713_(Blocks.f_49991_);
    }

    protected BlockPos scan(Direction dir, BlockPos pos, WorldGenLevel level, int scanDist) {
        int i;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        if (level.m_8055_(pos).m_60795_() && level.m_8055_(mutable.m_121945_(dir)).m_60804_((BlockGetter)level, pos)) {
            return pos;
        }
        for (i = 0; i < scanDist; ++i) {
            mutable.m_122173_(Direction.UP);
            if (!level.m_8055_((BlockPos)mutable).m_60795_() || !level.m_8055_(mutable.m_121945_(dir)).m_60804_((BlockGetter)level, pos)) continue;
            return new BlockPos(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_());
        }
        mutable = pos.m_122032_();
        for (i = 0; i < scanDist; ++i) {
            mutable.m_122173_(dir);
            if (!level.m_8055_(mutable.m_121945_(dir)).m_60804_((BlockGetter)level, pos) || !level.m_8055_(mutable.m_121945_(dir.m_122424_())).m_60795_()) continue;
            return new BlockPos(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_());
        }
        return pos;
    }

    protected static void growPointyStone(LevelAccessor pLevel, BlockPos pPos, Direction pDirection, int pHeight, boolean pMergeTip, StoneClusterConfiguration config) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        for (int l = 0; l == pHeight; ++l) {
            if (!pLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60804_((BlockGetter)pLevel, (BlockPos)blockpos$mutableblockpos)) {
                pLevel.m_7731_((BlockPos)blockpos$mutableblockpos, config.stone_provider().m_213972_(RandomSource.m_216327_(), (BlockPos)blockpos$mutableblockpos), 2);
            }
            blockpos$mutableblockpos.m_122173_(pDirection);
        }
    }
}

