/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.advancements;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lightning.northstar.advancements.NorthstarAdvancement;
import com.lightning.northstar.block.tech.telescope.TelescopeBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.GravelBlock;

public class NorthstarAdvancements
implements DataProvider {
    public static final List<NorthstarAdvancement> ENTRIES = new ArrayList<NorthstarAdvancement>();
    public static final NorthstarAdvancement $ = null;
    public static final NorthstarAdvancement ROOT = NorthstarAdvancements.create("root", b -> b.icon((ItemLike)((TelescopeBlock)((Object)((Object)NorthstarBlocks.TELESCOPE.get()))).m_5456_()).title("Welcome to Northstar!").description("Shoot for the stars!").awardedForFree().special(NorthstarAdvancement.TaskType.SILENT));
    public static final NorthstarAdvancement ONE_SMALL_STEP = NorthstarAdvancements.create("one_small_step", b -> b.icon((ItemLike)((GravelBlock)NorthstarBlocks.MOON_SAND.get()).m_5456_()).title("One Small Step").description("Set foot on the moon").after(ROOT));
    public static final NorthstarAdvancement ONE_GIANT_LEAP = NorthstarAdvancements.create("one_giant_leap", b -> b.icon((ItemLike)((GravelBlock)NorthstarBlocks.MARS_SAND.get()).m_5456_()).title("One Giant Leap").description("Set foot on Mars").after(ONE_SMALL_STEP));
    private final PackOutput output;

    private static NorthstarAdvancement create(String id, UnaryOperator<NorthstarAdvancement.Builder> b) {
        return new NorthstarAdvancement(id, b);
    }

    public NorthstarAdvancements(PackOutput output) {
        this.output = output;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ArrayList futures = new ArrayList();
        Path path = this.output.m_245114_();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_204017_3_ -> {
            if (!set.add(p_204017_3_.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + String.valueOf(p_204017_3_.m_138327_()));
            }
            Path path1 = NorthstarAdvancements.getPath(path, p_204017_3_);
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)p_204017_3_.m_138313_().m_138400_(), (Path)path1));
        };
        for (NorthstarAdvancement advancement : ENTRIES) {
            advancement.save(consumer);
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.m_138327_().m_135827_() + "/advancements/" + advancementIn.m_138327_().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Northstar's Advancements";
    }

    public static JsonObject provideLangEntries() {
        JsonObject object = new JsonObject();
        for (NorthstarAdvancement advancement : ENTRIES) {
            advancement.appendToLang(object);
        }
        return object;
    }

    public static void register() {
    }
}

