/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.crops;

import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public class MartianStrawberryBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 5;
    public static final IntegerProperty AGE = BlockStateProperties.f_61408_;
    private static final VoxelShape SAPLING_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public MartianStrawberryBushBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if ((Integer)pState.m_61143_((Property)AGE) == 0) {
            return SAPLING_SHAPE;
        }
        return (Integer)pState.m_61143_((Property)AGE) < 3 ? MID_GROWTH_SHAPE : super.m_5940_(pState, pLevel, pPos, pContext);
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_60713_((Block)NorthstarBlocks.MARS_FARMLAND.get());
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 5;
    }

    protected int getAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int pAge) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(pAge));
    }

    public boolean isMaxAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public boolean m_6724_(BlockState pState) {
        return !this.isMaxAge(pState);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        float f;
        int i;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.m_45524_(pPos, 0) >= 9 && (i = this.getAge(pState)) < this.getMaxAge() && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / (f = MartianStrawberryBushBlock.getGrowthSpeed((Block)this, (BlockGetter)pLevel, pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            pLevel.m_7731_(pPos, this.getStateForAge(i + 1), 2);
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        boolean flag;
        int i = (Integer)pState.m_61143_((Property)AGE);
        boolean bl = flag = i == 5;
        if (!flag && pPlayer.m_21120_(pHand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if ((Integer)pState.m_61143_((Property)AGE) == 5) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(3)), 8);
            MartianStrawberryBushBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)NorthstarItems.MARTIAN_STRAWBERRY.get(), pLevel.m_213780_().m_216339_(1, 3)));
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    public void growCrops(Level pLevel, BlockPos pPos, BlockState pState) {
        int j;
        int i = this.getAge(pState) + this.getBonemealAgeIncrease(pLevel);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        pLevel.m_7731_(pPos, this.getStateForAge(i), 2);
    }

    protected int getBonemealAgeIncrease(Level pLevel) {
        return Mth.m_216271_((RandomSource)pLevel.f_46441_, (int)1, (int)2);
    }

    protected static float getGrowthSpeed(Block pBlock, BlockGetter pLevel, BlockPos pPos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pPos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = pLevel.m_8055_(blockpos.m_7918_(i, 0, j));
                if (blockstate.canSustainPlant(pLevel, blockpos.m_7918_(i, 0, j), Direction.UP, (IPlantable)pBlock)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(pLevel, pPos.m_7918_(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pPos.m_122012_();
        BlockPos blockpos2 = pPos.m_122019_();
        BlockPos blockpos3 = pPos.m_122024_();
        BlockPos blockpos4 = pPos.m_122029_();
        boolean flag = pLevel.m_8055_(blockpos3).m_60713_(pBlock) || pLevel.m_8055_(blockpos4).m_60713_(pBlock);
        boolean bl = flag1 = pLevel.m_8055_(blockpos1).m_60713_(pBlock) || pLevel.m_8055_(blockpos2).m_60713_(pBlock);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = pLevel.m_8055_(blockpos3.m_122012_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos4.m_122012_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos4.m_122019_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos3.m_122019_()).m_60713_(pBlock);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return (pLevel.m_45524_(pPos, 0) >= 8 || pLevel.m_45527_(pPos)) && super.m_7898_(pState, pLevel, pPos);
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof Ravager && ForgeEventFactory.getMobGriefingEvent((Level)pLevel, (Entity)pEntity)) {
            pLevel.m_46953_(pPos, true, pEntity);
        }
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)NorthstarItems.MARTIAN_STRAWBERRY.get();
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack(this.getBaseSeedId());
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return !this.isMaxAge(pState);
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        this.growCrops((Level)pLevel, pPos, pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }
}

