/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.crops;

import com.lightning.northstar.content.NorthstarBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class VenusVinesBlock
extends Block
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape TIP_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final BooleanProperty IS_TIP = BooleanProperty.m_61465_((String)"is_tip");
    public static final IntegerProperty AGE = BlockStateProperties.f_61411_;
    public static final int MAX_AGE = 25;

    public VenusVinesBlock(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)IS_TIP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (((Boolean)pState.m_61143_((Property)IS_TIP)).booleanValue()) {
            return TIP_SHAPE;
        }
        return SHAPE;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rando) {
        BlockPos blockpos;
        if ((Integer)state.m_61143_((Property)AGE) < 25 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos.m_121945_(Direction.DOWN), (BlockState)level.m_8055_(pos.m_121945_(Direction.DOWN)), (rando.m_188500_() < 0.5 ? 1 : 0) != 0) && level.m_8055_(blockpos = pos.m_121945_(Direction.DOWN)).m_60795_()) {
            level.m_46597_(blockpos, this.getGrowIntoState(state, level.f_46441_));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)blockpos, (BlockState)level.m_8055_(blockpos));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{IS_TIP});
        builder.m_61104_(new Property[]{AGE});
    }

    protected BlockState getGrowIntoState(BlockState pState, RandomSource pRandom) {
        if (pRandom.m_188503_(4) == 0 && pState.m_60713_((Block)NorthstarBlocks.VENUS_VINES.get())) {
            return ((VenusVinesBlock)((Object)NorthstarBlocks.GLOWING_VENUS_VINES.get())).m_49966_();
        }
        if (pState.m_60713_((Block)NorthstarBlocks.GLOWING_VENUS_VINES.get()) && pRandom.m_188503_(2) != 0) {
            return ((VenusVinesBlock)((Object)NorthstarBlocks.VENUS_VINES.get())).m_49966_();
        }
        return (BlockState)pState.m_61122_((Property)AGE);
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return (Boolean)pState.m_61143_((Property)IS_TIP);
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        BlockPos blockpos = pPos.m_121945_(Direction.DOWN);
        int i = Math.min((Integer)pState.m_61143_((Property)AGE) + 1, 25);
        pLevel.m_46597_(blockpos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)));
        blockpos = blockpos.m_121945_(Direction.DOWN);
        i = Math.min(i + 1, 25);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pLevel.m_8055_(pCurrentPos.m_7494_()).m_60795_()) {
            return Blocks.f_50016_.m_49966_();
        }
        if (!pLevel.m_8055_(pCurrentPos.m_7495_()).m_60713_((Block)NorthstarBlocks.VENUS_VINES.get()) && !pLevel.m_8055_(pCurrentPos.m_7495_()).m_60713_((Block)NorthstarBlocks.GLOWING_VENUS_VINES.get())) {
            return (BlockState)this.m_49966_().m_61124_((Property)IS_TIP, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)IS_TIP, (Comparable)Boolean.valueOf(false));
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        if (pContext.m_43725_().m_8055_(pContext.m_8083_().m_7494_()).m_60795_()) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockState belowstate = pContext.m_43725_().m_8055_(pContext.m_8083_().m_7495_());
        if (!belowstate.m_60713_((Block)NorthstarBlocks.VENUS_VINES.get()) && !belowstate.m_60713_((Block)NorthstarBlocks.GLOWING_VENUS_VINES.get())) {
            return (BlockState)this.m_49966_().m_61124_((Property)IS_TIP, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)IS_TIP, (Comparable)Boolean.valueOf(false));
    }
}

