/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CrystalBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    protected final VoxelShape northAabb;
    protected final VoxelShape southAabb;
    protected final VoxelShape eastAabb;
    protected final VoxelShape westAabb;
    protected final VoxelShape upAabb;
    protected final VoxelShape downAabb;

    public CrystalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        int pOffset = 4;
        int pSize = 7;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING, (Comparable)Direction.UP));
        this.upAabb = Block.m_49796_((double)pOffset, (double)0.0, (double)pOffset, (double)(16 - pOffset), (double)pSize, (double)(16 - pOffset));
        this.downAabb = Block.m_49796_((double)pOffset, (double)(16 - pSize), (double)pOffset, (double)(16 - pOffset), (double)16.0, (double)(16 - pOffset));
        this.northAabb = Block.m_49796_((double)pOffset, (double)pOffset, (double)(16 - pSize), (double)(16 - pOffset), (double)(16 - pOffset), (double)16.0);
        this.southAabb = Block.m_49796_((double)pOffset, (double)pOffset, (double)0.0, (double)(16 - pOffset), (double)(16 - pOffset), (double)pSize);
        this.eastAabb = Block.m_49796_((double)0.0, (double)pOffset, (double)pOffset, (double)pSize, (double)(16 - pOffset), (double)(16 - pOffset));
        this.westAabb = Block.m_49796_((double)(16 - pSize), (double)pOffset, (double)pOffset, (double)16.0, (double)(16 - pOffset), (double)(16 - pOffset));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)FACING)) {
            case Direction.NORTH -> this.northAabb;
            case Direction.SOUTH -> this.southAabb;
            case Direction.EAST -> this.eastAabb;
            case Direction.WEST -> this.westAabb;
            case Direction.DOWN -> this.downAabb;
            default -> this.upAabb;
        };
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        BlockPos blockpos = pPos.m_121945_(direction.m_122424_());
        return pLevel.m_8055_(blockpos).m_60783_((BlockGetter)pLevel, blockpos, direction);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        BlockPos.MutableBlockPos blockpos = pCurrentPos.m_122032_();
        for (Direction direction : Direction.values()) {
            blockpos.m_122159_((Vec3i)pCurrentPos, direction);
            pLevel.m_186460_((BlockPos)blockpos, pLevel.m_8055_((BlockPos)blockpos).m_60734_(), 3);
        }
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return pDirection == ((Direction)pState.m_61143_((Property)FACING)).m_122424_() && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level levelaccessor = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)pContext.m_43719_());
    }

    @Deprecated
    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED, FACING});
    }

    @Deprecated
    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.DESTROY;
    }
}

