/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.simple.CrystalBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class LaserBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty DIRECTION = BlockStateProperties.f_61372_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61422_;

    public LaserBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(1)));
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        LaserBlock.updateColumn((LevelAccessor)pLevel, pPos, pState, pLevel.m_8055_(pPos.m_121945_(((Direction)pState.m_61143_((Property)DIRECTION)).m_122424_())));
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        double d0 = pPos.m_123341_();
        double d1 = pPos.m_123342_();
        double d2 = pPos.m_123343_();
        if (pRandom.m_188503_(200) == 0) {
            pLevel.m_7785_(d0, d1, d2, (SoundEvent)NorthstarSounds.LASER_AMBIENT.get(), SoundSource.BLOCKS, 0.2f + pRandom.m_188501_() * 0.2f, 0.9f + pRandom.m_188501_() * 0.15f, false);
        }
    }

    public static void updateColumn(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        LaserBlock.updateColumn(pLevel, pPos, pLevel.m_8055_(pPos), pState);
    }

    public static void updateColumn(LevelAccessor pLevel, BlockPos pPos, BlockState pLaser, BlockState pState) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        BlockState blockstate = LaserBlock.getLaserState(pState, (Level)pLevel, pPos);
        Direction dir = pState.m_60713_((Block)NorthstarBlocks.LASER.get()) || pState.m_60713_((Block)NorthstarBlocks.AMETHYST_CRYSTAL.get()) ? (Direction)pState.m_61143_((Property)DIRECTION) : (pState.m_60713_(Blocks.f_50016_) ? (Direction)pLaser.m_61143_((Property)DIRECTION) : Direction.DOWN);
        if (pState.m_60734_() == NorthstarBlocks.LASER_LENSE.get()) {
            blockpos$mutableblockpos = pPos.m_7495_().m_122032_();
        }
        while (pLevel.m_8055_((BlockPos)blockpos$mutableblockpos) == Blocks.f_50016_.m_49966_() || pLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() == NorthstarBlocks.LASER.get() || pLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() == NorthstarBlocks.AMETHYST_CRYSTAL.get()) {
            boolean crystal_flag;
            if (pLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() == NorthstarBlocks.AMETHYST_CRYSTAL.get()) {
                crystal_flag = true;
                if (pLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_61143_((Property)CrystalBlock.FACING) == dir.m_122424_()) {
                    return;
                }
                dir = (Direction)pLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_61143_((Property)CrystalBlock.FACING);
                if (blockstate.m_60734_() != Blocks.f_50016_) {
                    blockstate = (BlockState)blockstate.m_61124_((Property)DIRECTION, (Comparable)dir);
                }
                blockpos$mutableblockpos.m_122173_(dir);
                Northstar.LOGGER.debug("AMETHYST DETECTED!");
            } else {
                crystal_flag = false;
            }
            if (blockstate != Blocks.f_50016_.m_49966_() && !crystal_flag) {
                blockstate = (BlockState)blockstate.m_61124_((Property)DIRECTION, (Comparable)dir);
            }
            if (!pLevel.m_7731_((BlockPos)blockpos$mutableblockpos, blockstate, 2) && crystal_flag) {
                return;
            }
            blockpos$mutableblockpos.m_122173_(dir);
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pEntity.m_5825_()) {
            pEntity.m_7311_(pEntity.m_20094_() + 1);
            if (pEntity.m_20094_() == 0) {
                pEntity.m_20254_(8);
            }
        }
        pEntity.m_6469_(pLevel.m_269111_().m_269387_(), 4.0f);
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    private static BlockState getLaserState(BlockState pBlockState, Level level, BlockPos pos) {
        if (pBlockState.m_60713_((Block)NorthstarBlocks.LASER.get())) {
            return pBlockState;
        }
        if (pBlockState.m_60713_((Block)NorthstarBlocks.LASER_LENSE.get())) {
            return NorthstarBlocks.LASER.getDefaultState();
        }
        if (pBlockState.m_60713_((Block)NorthstarBlocks.AMETHYST_CRYSTAL.get())) {
            int count = 0;
            BlockPos.MutableBlockPos blockpos = pos.m_122032_();
            for (Direction direction : Direction.values()) {
                blockpos.m_122159_((Vec3i)pos, direction);
                if (!level.m_8055_((BlockPos)blockpos).m_60713_((Block)NorthstarBlocks.LASER.get())) continue;
                ++count;
            }
            if (count > 1) {
                return (BlockState)NorthstarBlocks.LASER.getDefaultState().m_61124_((Property)DIRECTION, (Comparable)((Direction)pBlockState.m_61143_((Property)CrystalBlock.FACING)));
            }
            return Blocks.f_50016_.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{DIRECTION, WATERLOGGED, POWER});
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.m_61143_((Property)DIRECTION);
        BlockPos blockpos = pPos.m_121945_(direction.m_122424_());
        if (direction != Direction.DOWN) {
            Northstar.LOGGER.debug("{}", (Object)pLevel.m_8055_(blockpos).m_60713_((Block)NorthstarBlocks.AMETHYST_CRYSTAL.get()));
            return true;
        }
        return pLevel.m_8055_(blockpos).m_60713_((Block)NorthstarBlocks.LASER.get()) || pLevel.m_8055_(blockpos).m_60713_((Block)NorthstarBlocks.LASER_LENSE.get()) || pLevel.m_8055_(blockpos).m_60713_((Block)NorthstarBlocks.AMETHYST_CRYSTAL.get());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)pContext.m_43719_());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)DIRECTION, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)DIRECTION)));
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.DESTROY;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        pLevel.m_186460_(pPos, (Block)this, 0);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }
}

