/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.block.simple.MarsSoilBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class MarsFarmlandBlock
extends FarmBlock {
    public MarsFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static void turntoMarsSoil(BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, MarsFarmlandBlock.m_49897_((BlockState)state, (BlockState)((MarsSoilBlock)((Object)NorthstarBlocks.MARS_SOIL.get())).m_49966_(), (LevelAccessor)level, (BlockPos)pos));
    }

    private static boolean isNearWater(LevelReader level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)level, pos, level.m_6425_(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos);
    }

    private static boolean isUnderCrops(BlockGetter block, BlockPos pos) {
        BlockState plant = block.m_8055_(pos.m_7494_());
        BlockState state = block.m_8055_(pos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(block, pos, Direction.UP, (IPlantable)plant.m_60734_());
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        return super.m_7898_(state, level, pos) || aboveState.m_60734_() instanceof StemGrownBlock;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((MarsSoilBlock)((Object)NorthstarBlocks.MARS_SOIL.get())).m_49966_() : super.m_5573_(context);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            MarsFarmlandBlock.turntoMarsSoil(state, (Level)level, pos);
        }
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos pos, Entity entity, float p_153231_) {
        if (!level.f_46443_ && ForgeHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)Blocks.f_50493_.m_49966_(), (float)p_153231_, (Entity)entity)) {
            MarsFarmlandBlock.turntoMarsSoil(blockState, level, pos);
        }
    }

    public void m_213898_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource p_221142_) {
        int i = (Integer)blockState.m_61143_((Property)f_53243_);
        if (!MarsFarmlandBlock.isNearWater((LevelReader)level, pos) && !level.m_46758_(pos.m_7494_())) {
            if (i > 0) {
                level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!MarsFarmlandBlock.isUnderCrops((BlockGetter)level, pos)) {
                MarsFarmlandBlock.turntoMarsSoil(blockState, (Level)level, pos);
            }
        } else if (i < 7) {
            level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        return plantType == PlantType.CROP || plantType == PlantType.PLAINS;
    }
}

