/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MercuryShelfFungusBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final int MIN_SHELVES = 1;
    public static final int MAX_SHELVES = 6;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty SHELVES = IntegerProperty.m_61631_((String)"shelves", (int)1, (int)6);
    protected static final float AABB_OFFSET = 2.5f;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)2.0, (double)3.0, (double)11.0, (double)14.0, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)3.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)2.0, (double)5.0, (double)13.0, (double)14.0)));

    public MercuryShelfFungusBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SHELVES, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return MercuryShelfFungusBlock.getShape(pState);
    }

    public static VoxelShape getShape(BlockState pState) {
        return AABBS.get(pState.m_61143_((Property)FACING));
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return pState.m_60819_().m_76178_();
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return pType == PathComputationType.AIR && !this.f_60443_ ? true : super.m_7357_(pState, pLevel, pPos, pType);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing.m_122424_() == pState.m_61143_((Property)FACING) && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : pState;
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        return pUseContext.m_43722_().m_150930_(this.m_5456_());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction[] adirection;
        BlockState blockstate = this.m_49966_();
        BlockState clickedState = pContext.m_43725_().m_8055_(pContext.m_8083_());
        if (clickedState.m_60713_(blockstate.m_60734_())) {
            return (BlockState)clickedState.m_61124_((Property)SHELVES, (Comparable)Integer.valueOf(Math.min(6, (Integer)clickedState.m_61143_((Property)SHELVES) + 1)));
        }
        FluidState fluidState = pContext.m_43725_().m_6425_(pContext.m_8083_());
        Level levelreader = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        for (Direction direction : adirection = pContext.m_6232_()) {
            Direction direction1;
            if (!direction.m_122434_().m_122479_() || !(blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)(direction1 = direction.m_122424_()))).m_60710_((LevelReader)levelreader, blockpos)) continue;
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        BlockPos blockpos = pPos.m_121945_(direction.m_122424_());
        BlockState blockstate = pLevel.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)pLevel, blockpos, direction);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, WATERLOGGED, SHELVES});
    }

    public BlockState getStateForGeneration(BlockState state, WorldGenLevel level, BlockPos blockpos1, Direction direction) {
        BlockState blockstate = this.m_49966_();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (!level.m_8055_(blockpos1.m_121945_(dir)).m_60804_((BlockGetter)level, blockpos1.m_121945_(dir))) continue;
            blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)dir);
        }
        if (blockstate != this.m_49966_()) {
            return blockstate;
        }
        return null;
    }
}

