/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.particle.ColdAirParticleData;
import com.lightning.northstar.world.NorthstarTemperature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MethaneIceBlock
extends HalfTransparentBlock {
    public MethaneIceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, pState, pTe, pStack);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)pStack) == 0) {
            if ((float)NorthstarTemperature.getBoilingPoint(NorthstarFluids.METHANE.getSource().m_76145_()) < NorthstarTemperature.getTemperatureAt(pLevel, (Vec3i)pPos)) {
                this.evaporate(pState, pLevel, pPos);
            } else if ((float)NorthstarTemperature.getFreezingPoint(NorthstarFluids.METHANE.getSource().m_76145_()) < NorthstarTemperature.getTemperatureAt(pLevel, (Vec3i)pPos)) {
                this.melt(pState, pLevel, pPos);
            }
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (random.m_188503_(5) != 0 && NorthstarTemperature.getTemperatureAt(level, (Vec3i)pos) < (float)NorthstarTemperature.getFreezingPoint(NorthstarFluids.METHANE.getSource().m_76145_())) {
            return;
        }
        for (Direction dir : Direction.values()) {
            if (!level.m_8055_(pos.m_121945_(dir)).m_204336_(NorthstarTags.NorthstarBlockTags.AIR_PASSES_THROUGH.tag) || random.m_188503_(20) != 0) continue;
            double d0 = (double)x + (double)(dir.m_122429_() / 2) + random.m_188500_();
            double d1 = (double)y + 0.7;
            double d2 = (double)z + (double)(dir.m_122431_() / 2) + random.m_188500_();
            level.m_7106_((ParticleOptions)new ColdAirParticleData(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((float)NorthstarTemperature.getBoilingPoint(NorthstarFluids.METHANE.getSource().m_76145_()) < NorthstarTemperature.getTemperatureAt((Level)pLevel, (Vec3i)pPos)) {
            this.evaporate(pState, (Level)pLevel, pPos);
        } else if ((float)NorthstarTemperature.getFreezingPoint(NorthstarFluids.METHANE.getSource().m_76145_()) < NorthstarTemperature.getTemperatureAt((Level)pLevel, (Vec3i)pPos)) {
            this.melt(pState, (Level)pLevel, pPos);
        }
    }

    protected void melt(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.m_46597_(pPos, NorthstarFluids.METHANE.getSource().getFluidType().getBlockForFluidState((BlockAndTintGetter)pLevel, pPos, NorthstarFluids.METHANE.getSource().m_76145_()));
        pLevel.m_46586_(pPos, NorthstarFluids.METHANE.getSource().getFluidType().getBlockForFluidState((BlockAndTintGetter)pLevel, pPos, NorthstarFluids.METHANE.getSource().m_76145_()).m_60734_(), pPos);
    }

    protected void evaporate(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.m_46597_(pPos, Blocks.f_50016_.m_49966_());
        pLevel.m_46586_(pPos, Blocks.f_50016_, pPos);
        int i = pPos.m_123341_();
        int j = pPos.m_123342_();
        int k = pPos.m_123343_();
        pLevel.m_5594_(null, pPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (pLevel.f_46441_.m_188501_() - pLevel.f_46441_.m_188501_()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

