/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import org.jetbrains.annotations.Nullable;

public class VenusMushroomBlock
extends BushBlock
implements BonemealableBlock {
    protected static final BooleanProperty IS_ON_CEILING = BooleanProperty.m_61465_((String)"is_on_ceiling");
    protected static final VoxelShape GROUND_SHAPE = VenusMushroomBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    protected static final VoxelShape CEILING_SHAPE = VenusMushroomBlock.m_49796_((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private final ResourceKey<ConfiguredFeature<?, ?>> ground;
    private final ResourceKey<ConfiguredFeature<?, ?>> ceiling;

    public VenusMushroomBlock(BlockBehaviour.Properties properties, ResourceKey<ConfiguredFeature<?, ?>> ground, ResourceKey<ConfiguredFeature<?, ?>> ceiling) {
        super(properties);
        this.ground = ground;
        this.ceiling = ceiling;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{IS_ON_CEILING}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)IS_ON_CEILING) != false ? CEILING_SHAPE : GROUND_SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos otherPos = (Boolean)state.m_61143_((Property)IS_ON_CEILING) != false ? pos.m_7494_() : pos.m_7495_();
        Direction direction = (Boolean)state.m_61143_((Property)IS_ON_CEILING) != false ? Direction.DOWN : Direction.UP;
        BlockState blockstate = level.m_8055_(otherPos);
        return blockstate.m_204336_(BlockTags.f_13057_) || blockstate.canSustainPlant((BlockGetter)level, otherPos, direction, (IPlantable)this);
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60804_(level, pos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(context.m_43719_() == Direction.DOWN));
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return ((Boolean)state.m_61143_((Property)IS_ON_CEILING)).booleanValue() ? ((VenusMushroomBlock)state.m_60734_()).ceiling != null : ((VenusMushroomBlock)state.m_60734_()).ground != null;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return ((Boolean)state.m_61143_((Property)IS_ON_CEILING)).booleanValue() ? ((VenusMushroomBlock)state.m_60734_()).ceiling != null : ((VenusMushroomBlock)state.m_60734_()).ground != null;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        Optional feature = level.m_9598_().m_175515_(Registries.f_256911_).m_203636_((Boolean)state.m_61143_((Property)IS_ON_CEILING) != false ? this.ceiling : this.ground);
        if (feature.isEmpty()) {
            return;
        }
        SaplingGrowTreeEvent event = ForgeEventFactory.blockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, (Holder)((Holder)feature.get()));
        if (event.isCanceled()) {
            return;
        }
        level.m_7471_(pos, false);
        if (((ConfiguredFeature)event.getFeature().m_203334_()).m_224953_((WorldGenLevel)level, level.m_7726_().m_8481_(), random, pos)) {
            return;
        }
        level.m_7731_(pos, state, 3);
    }
}

