/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.block.simple.VerticalSlabType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.m_61587_((String)"type", VerticalSlabType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);

    public VerticalSlabBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public boolean m_7923_(BlockState pState) {
        return pState.m_61143_(TYPE) != VerticalSlabType.DOUBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{TYPE, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((VerticalSlabType)((Object)pState.m_61143_(TYPE))) {
            case VerticalSlabType.DOUBLE -> Shapes.m_83144_();
            case VerticalSlabType.EAST -> EAST_SHAPE;
            case VerticalSlabType.WEST -> WEST_SHAPE;
            case VerticalSlabType.SOUTH -> SOUTH_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        BlockState blockstate = pContext.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)((BlockState)blockstate.m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        FluidState fluidstate = pContext.m_43725_().m_6425_(blockpos);
        Direction direction = pContext.m_8125_();
        VerticalSlabType bob = switch (direction) {
            case Direction.SOUTH -> VerticalSlabType.SOUTH;
            case Direction.EAST -> VerticalSlabType.EAST;
            case Direction.WEST -> VerticalSlabType.WEST;
            default -> VerticalSlabType.NORTH;
        };
        return (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)bob))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        VerticalSlabType slabtype = (VerticalSlabType)((Object)pState.m_61143_(TYPE));
        if (slabtype != VerticalSlabType.DOUBLE && itemstack.m_150930_(this.m_5456_())) {
            if (pUseContext.m_7058_()) {
                boolean flag = pUseContext.m_43720_().f_82480_ - (double)pUseContext.m_8083_().m_123342_() > 0.5;
                Direction direction = pUseContext.m_43719_();
                if (slabtype == VerticalSlabType.NORTH) {
                    return direction == Direction.EAST || flag && direction.m_122434_().m_122479_();
                }
                return direction == Direction.WEST || !flag && direction.m_122434_().m_122479_();
            }
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        return pState.m_61143_(TYPE) != VerticalSlabType.DOUBLE ? super.m_7361_(pLevel, pPos, pState, pFluidState) : false;
    }

    public boolean m_6044_(BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        return pState.m_61143_(TYPE) != VerticalSlabType.DOUBLE ? super.m_6044_(pLevel, pPos, pState, pFluid) : false;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.fromDir(rotation.m_55954_(VerticalSlabType.toDir((VerticalSlabType)((Object)blockState.m_61143_(TYPE)))))));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_(VerticalSlabType.toDir((VerticalSlabType)((Object)blockState.m_61143_(TYPE)))));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return switch (pType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.AIR, PathComputationType.LAND -> false;
            case PathComputationType.WATER -> pLevel.m_6425_(pPos).m_205070_(FluidTags.f_13131_);
        };
    }
}

