/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_concentrator;

import com.lightning.northstar.block.tech.oxygen_concentrator.OxygenConcentratorBlock;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class OxygenConcentratorBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public int airLevel;
    public int airTimer;
    public SmartFluidTankBehaviour tank;

    public OxygenConcentratorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToGoggleTooltip(tooltip, isPlayerSneaking)) {
            tooltip.add((Component)Component.m_237119_());
        }
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability().cast());
        return true;
    }

    public void tick() {
        super.tick();
        if (this.speed == 0.0f || this.overStressed) {
            return;
        }
        float abs = Math.abs(this.getSpeed());
        int increment = Mth.m_14045_((int)(((int)abs - 100) / 200), (int)1, (int)5);
        this.airLevel = Math.min(500, this.airLevel + increment);
        ResourceKey dimension = this.f_58857_.m_46472_();
        if (dimension.equals((Object)Level.f_46428_)) {
            this.tank.getPrimaryHandler().fill(new FluidStack((Fluid)NorthstarFluids.OXYGEN.get(), increment), IFluidHandler.FluidAction.EXECUTE);
        } else if (dimension.equals(NorthstarDimensions.MARS_DIM_KEY) || dimension.equals(NorthstarDimensions.VENUS_DIM_KEY)) {
            this.tank.getPrimaryHandler().fill(new FluidStack((Fluid)NorthstarFluids.CARBON.get(), increment), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Air", this.airLevel);
        compound.m_128405_("Timer", this.airTimer);
    }

    public void writeSafe(CompoundTag compound) {
        super.writeSafe(compound);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.airLevel = compound.m_128451_("Air");
        this.airTimer = compound.m_128451_("Timer");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == ((Direction)this.m_58900_().m_61143_(OxygenConcentratorBlock.HORIZONTAL_FACING)).m_122424_()) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }
}

