/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_sealer;

import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.world.NorthstarOxygen;
import com.lightning.northstar.world.SealingProvider;
import com.lightning.northstar.world.sealer.ProgressiveBlockSealer;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MovingOxygenSealer
implements SealingProvider {
    public final Contraption contraption;
    public final ProgressiveBlockSealer sealer = new ProgressiveBlockSealer();
    public float pendingDrain;
    public boolean active;

    MovingOxygenSealer(Contraption contraption) {
        this.contraption = contraption;
    }

    void tick(MovementContext context) {
        if (this.sealer.isSealInProgress()) {
            this.sealer.updateSeal((Level)context.contraption.getContraptionWorld(), (Integer)NorthstarConfigs.server().oxygenSealerMaxContraptionSealed.get());
        } else {
            this.sealer.beginSeal((Level)context.contraption.getContraptionWorld(), context.localPos, Direction.UP);
        }
        this.active = false;
        if (this.sealer.hasLeak()) {
            return;
        }
        MountedFluidStorageWrapper fluids = context.contraption.getStorage().getFluids();
        Fluid oxygen = MovingOxygenSealer.findOxygenIn(fluids);
        if (oxygen == null) {
            return;
        }
        this.pendingDrain -= (float)fluids.drain(new FluidStack(oxygen, (int)this.pendingDrain), context.world.f_46443_ ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE).getAmount();
        if (this.pendingDrain >= 1.0f) {
            return;
        }
        this.pendingDrain += NorthstarConfigs.server().oxygenSealerOxygenPerBlockPerTick.getF() * (float)this.sealer.getSealedBlockCount();
        this.active = true;
    }

    @Override
    public boolean isSealed(Vec3 pos) {
        if (!this.active) {
            return false;
        }
        Vec3 local = this.contraption.entity.toLocalVector(pos, 0.0f);
        return this.sealer.getSealedBlocks().contains(BlockPos.m_121882_((int)Mth.m_14107_((double)local.f_82479_), (int)Mth.m_14107_((double)local.f_82480_), (int)Mth.m_14107_((double)local.f_82481_)));
    }

    @Override
    public boolean isSealed(Vec3i pos) {
        return this.isSealed(Vec3.m_82528_((Vec3i)pos));
    }

    private static Fluid findOxygenIn(MountedFluidStorageWrapper fluids) {
        for (int i = 0; i < fluids.getTanks(); ++i) {
            Fluid fluid = fluids.getFluidInTank(i).getFluid();
            if (!NorthstarOxygen.isOxygen(fluid)) continue;
            return fluid;
        }
        return null;
    }
}

