/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.solar_panel;

import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class SolarPanelBlockEntity
extends GeneratingKineticBlockEntity {
    public static final int MAXIMUM_SPEED = 16;
    public final LerpedFloat targetAngle = LerpedFloat.angular();
    private int lastLight = -1;
    private float generatedSpeed;
    private int ticksSinceChange;

    public SolarPanelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        int light = Math.max(0, this.f_58857_.m_45517_(LightLayer.SKY, this.f_58858_) - this.f_58857_.m_7445_());
        if (light != this.lastLight && this.ticksSinceChange++ >= 40) {
            this.lastLight = light;
            this.generatedSpeed = (float)(16 * light) / 15.0f * NorthstarPlanets.getSunMultiplier((ResourceKey<Level>)this.f_58857_.m_46472_());
            this.ticksSinceChange = 0;
            this.updateGeneratedRotation();
        }
        if (this.f_58857_.m_5776_()) {
            this.targetAngle.tickChaser();
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.generatedSpeed = compound.m_128457_("GeneratorSpeed");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("GeneratorSpeed", this.generatedSpeed);
    }

    public float getGeneratedSpeed() {
        return this.generatedSpeed;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(1.0);
    }
}

