/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.telescope;

import com.google.common.collect.Lists;
import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.telescope.TelescopeBlockEntity;
import com.lightning.northstar.block.tech.telescope.TelescopeMenu;
import com.lightning.northstar.block.tech.telescope.TelescopePrintPacket;
import com.lightning.northstar.content.NorthstarPackets;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TelescopeScreen
extends AbstractSimiContainerScreen<TelescopeMenu> {
    private static final ResourceLocation TELESCOPE_TEXTURE = Northstar.asResource("textures/gui/telescope_gui.png");
    private static final ResourceLocation TELESCOPE_TEXTURE_SIDE = Northstar.asResource("textures/gui/telescope_gui_side.png");
    private static final ResourceLocation MERCURY = Northstar.asResource("textures/environment/mercury_far.png");
    private static final ResourceLocation VENUS = Northstar.asResource("textures/environment/venus_far.png");
    private static final ResourceLocation EARTH = Northstar.asResource("textures/environment/earth_far.png");
    private static final ResourceLocation MOON = Northstar.asResource("textures/environment/moon_far.png");
    private static final ResourceLocation MARS = Northstar.asResource("textures/environment/mars_far.png");
    private static final ResourceLocation PHOBOS_DEIMOS = Northstar.asResource("textures/environment/phobos_and_deimos_far.png");
    private static final ResourceLocation CERES = Northstar.asResource("textures/environment/ceres_far.png");
    private static final ResourceLocation JUPITER = Northstar.asResource("textures/environment/jupiter_far.png");
    private static final ResourceLocation SATURN = Northstar.asResource("textures/environment/saturn_far.png");
    private static final ResourceLocation URANUS = Northstar.asResource("textures/environment/uranus_far.png");
    private static final ResourceLocation NEPTUNE = Northstar.asResource("textures/environment/neptune_far.png");
    private static final ResourceLocation PLUTO = Northstar.asResource("textures/environment/pluto_far.png");
    private static final ResourceLocation ERIS = Northstar.asResource("textures/environment/eris_far.png");
    private static final ResourceLocation BACKGROUND = Northstar.asResource("textures/environment/space_background.png");
    private static final ResourceLocation MOON_GLOW = ResourceLocation.parse((String)"textures/environment/moon_phases.png");
    private static final ResourceLocation MOON_FLAT = Northstar.asResource("textures/environment/moon_flat.png");
    private boolean isScrolling;
    private double scrollX = 450.0;
    private double scrollY = 450.0;
    private Inventory inv;
    public String selectedPlanet = null;

    public TelescopeScreen(TelescopeMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.inv = inv;
        this.f_97726_ = 300;
        this.f_97727_ = 300;
        this.f_97728_ = 150;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        IconButton printButton = new IconButton(x - 33, y + 200, (ScreenElement)AllIcons.I_ADD);
        printButton.withCallback(() -> {
            if (this.selectedPlanet != null) {
                NorthstarPackets.getChannel().sendToServer((Object)TelescopePrintPacket.print(((TelescopeBlockEntity)((Object)((Object)((TelescopeMenu)this.f_97732_).contentHolder))).m_58899_(), this.selectedPlanet));
            }
        });
        printButton.f_93623_ = this.paperCheck();
        printButton.setToolTip((Component)Component.m_237115_((String)"northstar.gui.telescope.button_tooltip"));
        this.m_142416_((GuiEventListener)printButton);
    }

    protected void m_280003_(GuiGraphics graphics, int pMouseX, int pMouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.f_97729_, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280588_(x + 3, y + 3, x + this.f_97726_ - 3, y + this.f_97727_ - 3);
        graphics.m_280163_(BACKGROUND, x, y, (float)((int)(-this.scrollX)), (float)((int)(-this.scrollY)), this.f_97726_, this.f_97727_, 900, 900);
        this.renderPlanets(graphics, mouseX, mouseY, partialTick);
        graphics.m_280618_();
        graphics.m_280163_(TELESCOPE_TEXTURE_SIDE, x - 174, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        graphics.m_280163_(TELESCOPE_TEXTURE, x, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
        this.renderPlanetTooltips(graphics, mouseX, mouseY);
        this.renderSelectedPlanet(graphics);
    }

    public void renderPlanets(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        PoseStack pose = graphics.m_280168_();
        ResourceKey player_dim = Minecraft.m_91087_().f_91074_.m_9236_().m_46472_();
        if (player_dim != NorthstarDimensions.MARS_DIM_KEY) {
            int mars_x = (int)NorthstarPlanets.mars_x;
            int mars_y = (int)NorthstarPlanets.mars_y;
            pose.m_85836_();
            pose.m_85841_(0.05f, 0.05f, 0.05f);
            graphics.m_280218_(MARS, mars_x * 20 + (int)this.scrollX * 20, mars_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.m_85849_();
            int pd_x = (int)NorthstarPlanets.pd_x;
            int pd_y = (int)NorthstarPlanets.pd_y;
            pose.m_85836_();
            pose.m_85841_(0.05f, 0.05f, 0.05f);
            graphics.m_280218_(PHOBOS_DEIMOS, pd_x * 20 + (int)this.scrollX * 20, pd_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.m_85849_();
        }
        if (player_dim != NorthstarDimensions.VENUS_DIM_KEY) {
            int venus_x = (int)NorthstarPlanets.venus_x;
            int venus_y = (int)NorthstarPlanets.venus_y;
            pose.m_85836_();
            pose.m_85841_(0.05f, 0.05f, 0.05f);
            graphics.m_280218_(VENUS, venus_x * 20 + (int)this.scrollX * 20, venus_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.m_85849_();
        }
        if (player_dim != NorthstarDimensions.MERCURY_DIM_KEY) {
            int mercury_x = (int)NorthstarPlanets.mercury_x;
            int mercury_y = (int)NorthstarPlanets.mercury_y;
            pose.m_85836_();
            pose.m_85841_(0.05f, 0.05f, 0.05f);
            graphics.m_280218_(MERCURY, mercury_x * 20 + (int)this.scrollX * 20, mercury_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.m_85849_();
        }
        int jupiter_x = (int)NorthstarPlanets.jupiter_x;
        int jupiter_y = (int)NorthstarPlanets.jupiter_y;
        pose.m_85836_();
        pose.m_85841_(0.05f, 0.05f, 0.05f);
        graphics.m_280218_(JUPITER, jupiter_x * 20 + (int)this.scrollX * 20, jupiter_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.m_85849_();
        int saturn_x = (int)NorthstarPlanets.saturn_x;
        int saturn_y = (int)NorthstarPlanets.saturn_y;
        pose.m_85836_();
        pose.m_85841_(0.05f, 0.05f, 0.05f);
        graphics.m_280218_(SATURN, saturn_x * 20 + (int)this.scrollX * 20, saturn_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.m_85849_();
        int uranus_x = (int)NorthstarPlanets.uranus_x;
        int uranus_y = (int)NorthstarPlanets.uranus_y;
        pose.m_85836_();
        pose.m_85841_(0.05f, 0.05f, 0.05f);
        graphics.m_280218_(URANUS, uranus_x * 20 + (int)this.scrollX * 20, uranus_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.m_85849_();
        int neptune_x = (int)NorthstarPlanets.neptune_x;
        int neptune_y = (int)NorthstarPlanets.neptune_y;
        pose.m_85836_();
        pose.m_85841_(0.05f, 0.05f, 0.05f);
        graphics.m_280218_(NEPTUNE, neptune_x * 20 + (int)this.scrollX * 20, neptune_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.m_85849_();
        int pluto_x = (int)NorthstarPlanets.pluto_x;
        int pluto_y = (int)NorthstarPlanets.pluto_x;
        pose.m_85836_();
        pose.m_85841_(0.05f, 0.05f, 0.05f);
        graphics.m_280218_(PLUTO, pluto_x * 20 + (int)this.scrollX * 20, pluto_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.m_85849_();
        int eris_x = (int)NorthstarPlanets.eris_x;
        int eris_y = (int)NorthstarPlanets.eris_y;
        pose.m_85836_();
        pose.m_85841_(0.05f, 0.05f, 0.05f);
        graphics.m_280218_(ERIS, eris_x * 20 + (int)this.scrollX * 20, eris_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
        pose.m_85849_();
        if (player_dim != ClientLevel.f_46428_ && player_dim != NorthstarDimensions.MOON_DIM_KEY) {
            int earth_x = (int)NorthstarPlanets.earth_x;
            int earth_y = (int)NorthstarPlanets.earth_y;
            pose.m_85836_();
            pose.m_85841_(0.05f, 0.05f, 0.05f);
            graphics.m_280218_(EARTH, earth_x * 20 + (int)this.scrollX * 20, earth_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.m_85849_();
            int moon_x = (int)NorthstarPlanets.moon_x;
            int moon_y = (int)NorthstarPlanets.moon_y;
            pose.m_85836_();
            pose.m_85841_(0.05f, 0.05f, 0.05f);
            graphics.m_280218_(MOON, moon_x * 20 + (int)this.scrollX * 20, moon_y * 20 + (int)this.scrollY * 20, 0, 0, 255, 255);
            pose.m_85849_();
        }
        if (player_dim == ClientLevel.f_46428_) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            pose.m_85836_();
            pose.m_85841_(2.0f, 1.0f, 1.0f);
            int moon_phase = Minecraft.m_91087_().f_91073_.m_46941_();
            int moon_uv_x = moon_phase % 4 * 64;
            int moon_uv_y = moon_phase / 4 * 128;
            graphics.m_280218_(MOON_GLOW, (int)NorthstarPlanets.earth_moon_x + (int)this.scrollX / 2 - 27, (int)NorthstarPlanets.earth_moon_y + (int)this.scrollY - 57, 0 + moon_uv_x, 0 + moon_uv_y, 64, 128);
            pose.m_85849_();
            pose.m_85836_();
            RenderSystem.disableBlend();
            pose.m_85841_(2.0f, 1.0f, 1.0f);
            graphics.m_280218_(MOON_FLAT, (int)NorthstarPlanets.earth_moon_x + (int)this.scrollX / 2 - 27, (int)NorthstarPlanets.earth_moon_y + (int)this.scrollY - 57, 0 + moon_uv_x, 0 + moon_uv_y, 64, 128);
            pose.m_85849_();
        }
    }

    public boolean paperCheck() {
        if (this.inv.f_35978_.m_7500_()) {
            return true;
        }
        boolean flag = false;
        if (this.inv != null) {
            for (int p = 0; p < 36; ++p) {
                ItemStack items = this.inv.m_8020_(p);
                Item item = items.m_41720_();
                if (item != Items.f_42516_) continue;
                flag = true;
            }
        }
        return flag;
    }

    public void renderSelectedPlanet(GuiGraphics graphics) {
        if (this.selectedPlanet != null) {
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            graphics.m_280163_(this.getPlanetSprite(this.selectedPlanet), x - 40, y + 93, 0.0f, 0.0f, 35, 35, 35, 35);
            graphics.m_280614_(this.f_96547_, this.getPlanetName(this.selectedPlanet), x - 45, y + 130, 6944, false);
            graphics.m_280056_(this.f_96547_, "X: " + (int)NorthstarPlanets.getPlanetX(this.selectedPlanet), x - 45, y + 140, 6944, false);
            graphics.m_280056_(this.f_96547_, "Y: " + (int)NorthstarPlanets.getPlanetY(this.selectedPlanet), x - 45, y + 150, 6944, false);
        }
    }

    public void renderPlanetTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        int x = (this.f_96543_ - (this.f_97726_ + this.f_97726_ / 2)) / 2;
        int y = (this.f_96544_ - (this.f_97727_ + this.f_97727_ / 2)) / 2;
        ResourceKey player_dim = Minecraft.m_91087_().f_91074_.m_9236_().m_46472_();
        if (Math.abs(NorthstarPlanets.mars_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.mars_y + this.scrollY + 8.0 - (double)mouseY) < 8.0 && player_dim != NorthstarDimensions.MARS_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.mars.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.mars.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.mars.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.mars.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.mars.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.mars_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.mars_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.earth_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.earth_y + this.scrollY + 8.0 - (double)mouseY) < 8.0 && player_dim != ClientLevel.f_46428_) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.earth.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.earth.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.earth.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.earth.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.earth.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.earth_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.earth_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.moon_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.moon_y + this.scrollY + 8.0 - (double)mouseY) < 8.0 && player_dim != ClientLevel.f_46428_ && player_dim != NorthstarDimensions.MOON_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.moon.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.moon.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.moon.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.moon.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.moon.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.moon_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.moon_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.pd_x + this.scrollX + 5.0 - (double)mouseX) < 5.0 && Math.abs(NorthstarPlanets.pd_y + this.scrollY + 5.0 - (double)mouseY) < 5.0 && player_dim != NorthstarDimensions.MARS_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.phobos_deimos.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.phobos_deimos.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.phobos_deimos.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.phobos_deimos.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.phobos_deimos.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.pd_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.pd_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.venus_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.venus_y + this.scrollY + 8.0 - (double)mouseY) < 8.0 && player_dim != NorthstarDimensions.VENUS_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.venus.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.venus.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.venus.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.venus.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.venus.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.venus_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.venus_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.mercury_x + this.scrollX + 7.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.mercury_y + this.scrollY + 7.0 - (double)mouseY) < 8.0 && player_dim != NorthstarDimensions.MERCURY_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.mercury.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.mercury.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.mercury.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.mercury.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.mercury.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.mercury_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.mercury_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.earth_moon_x + this.scrollX - (double)mouseX) < 24.0 && Math.abs(NorthstarPlanets.earth_moon_y + this.scrollY - (double)mouseY) < 24.0 && player_dim == ClientLevel.f_46428_ && player_dim != NorthstarDimensions.MOON_DIM_KEY) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.moon.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.moon.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.moon.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.moon.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.moon.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.earth_moon_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.earth_moon_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.ceres_x + this.scrollX + 6.0 - (double)mouseX) < 6.0 && Math.abs(NorthstarPlanets.ceres_y + this.scrollY + 6.0 - (double)mouseY) < 6.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.ceres.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.ceres.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.ceres.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.ceres.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.ceres.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.ceres_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.ceres_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.jupiter_x + this.scrollX + 12.0 - (double)mouseX) < 12.0 && Math.abs(NorthstarPlanets.jupiter_y + this.scrollY + 12.0 - (double)mouseY) < 12.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.jupiter.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.jupiter.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.jupiter.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.jupiter.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.jupiter.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.jupiter_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.jupiter_x)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.saturn_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.saturn_y + this.scrollY + 8.0 - (double)mouseY) < 8.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.saturn.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.saturn.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.saturn.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.saturn.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.saturn.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.saturn_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.saturn_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.uranus_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.uranus_y + this.scrollY + 8.0 - (double)mouseY) < 8.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.uranus.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.uranus.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.uranus.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.uranus.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.uranus.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.uranus_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.uranus_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.neptune_x + this.scrollX + 8.0 - (double)mouseX) < 8.0 && Math.abs(NorthstarPlanets.neptune_y + this.scrollY + 8.0 - (double)mouseY) < 8.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.neptune.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.neptune.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.neptune.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.neptune.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.neptune.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.neptune_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.neptune_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.pluto_x + this.scrollX + 6.0 - (double)mouseX) < 6.0 && Math.abs(NorthstarPlanets.pluto_y + this.scrollY + 6.0 - (double)mouseY) < 6.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.pluto.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.pluto.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.pluto.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.pluto.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.pluto.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.pluto_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.pluto_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        } else if (Math.abs(NorthstarPlanets.eris_x + this.scrollX + 6.0 - (double)mouseX) < 6.0 && Math.abs(NorthstarPlanets.eris_y + this.scrollY + 6.0 - (double)mouseY) < 6.0) {
            ArrayList list = Lists.newArrayList();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            list.add(Component.m_237115_((String)"planets.eris.name").m_130940_(ChatFormatting.AQUA));
            list.add(Component.m_237115_((String)"planets.eris.type").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.eris.grav").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.eris.temp").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"planets.eris.atmosphere").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237113_((String)("X:  " + (int)NorthstarPlanets.eris_x)).m_130940_(ChatFormatting.WHITE));
            list.add(Component.m_237113_((String)("Y:  " + (int)NorthstarPlanets.eris_y)).m_130940_(ChatFormatting.WHITE));
            graphics.m_280666_(this.f_96547_, (List)list, mouseX, mouseY);
        }
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        }
        this.scroll(pDragX, pDragY);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int pButton) {
        if (pButton == 0 || pButton == 1) {
            if (Math.abs(NorthstarPlanets.mercury_x + this.scrollX + 7.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.mercury_y + this.scrollY + 7.0 - mouseY) < 8.0 && Minecraft.m_91087_().f_91073_.m_46472_() != NorthstarDimensions.MERCURY_DIM_KEY) {
                this.selectedPlanet = "mercury";
            }
            if (Math.abs(NorthstarPlanets.venus_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.venus_y + this.scrollY + 8.0 - mouseY) < 8.0 && Minecraft.m_91087_().f_91073_.m_46472_() != NorthstarDimensions.VENUS_DIM_KEY) {
                this.selectedPlanet = "venus";
            }
            if (Math.abs(NorthstarPlanets.earth_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.earth_y + this.scrollY + 8.0 - mouseY) < 8.0 && Minecraft.m_91087_().f_91073_.m_46472_() != Level.f_46428_) {
                this.selectedPlanet = "earth";
            }
            if (Math.abs(NorthstarPlanets.earth_moon_x + this.scrollX - mouseX) < 18.0 && Math.abs(NorthstarPlanets.earth_moon_y + this.scrollY - mouseY) < 18.0 && Minecraft.m_91087_().f_91073_.m_46472_() == Level.f_46428_ && Minecraft.m_91087_().f_91073_.m_46472_() != NorthstarDimensions.MOON_DIM_KEY) {
                this.selectedPlanet = "earth_moon";
            }
            if (Math.abs(NorthstarPlanets.moon_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.moon_y + this.scrollY + 8.0 - mouseY) < 8.0 && Minecraft.m_91087_().f_91073_.m_46472_() != Level.f_46428_ && Minecraft.m_91087_().f_91073_.m_46472_() != NorthstarDimensions.MOON_DIM_KEY) {
                this.selectedPlanet = "moon";
            }
            if (Math.abs(NorthstarPlanets.mars_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.mars_y + this.scrollY + 8.0 - mouseY) < 8.0 && Minecraft.m_91087_().f_91073_.m_46472_() != NorthstarDimensions.MARS_DIM_KEY) {
                this.selectedPlanet = "mars";
            }
            if (Math.abs(NorthstarPlanets.ceres_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.ceres_y + this.scrollY + 8.0 - mouseY) < 8.0) {
                this.selectedPlanet = "ceres";
            }
            if (Math.abs(NorthstarPlanets.jupiter_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.jupiter_y + this.scrollY + 8.0 - mouseY) < 8.0) {
                this.selectedPlanet = "jupiter";
            }
            if (Math.abs(NorthstarPlanets.saturn_x + this.scrollX + 8.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.saturn_y + this.scrollY + 8.0 - mouseY) < 8.0) {
                this.selectedPlanet = "saturn";
            }
            if (Math.abs(NorthstarPlanets.uranus_x + this.scrollX + 7.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.uranus_y + this.scrollY + 7.0 - mouseY) < 8.0) {
                this.selectedPlanet = "uranus";
            }
            if (Math.abs(NorthstarPlanets.neptune_x + this.scrollX + 7.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.neptune_y + this.scrollY + 7.0 - mouseY) < 8.0) {
                this.selectedPlanet = "neptune";
            }
            if (Math.abs(NorthstarPlanets.pluto_x + this.scrollX + 7.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.pluto_y + this.scrollY + 7.0 - mouseY) < 8.0) {
                this.selectedPlanet = "pluto";
            }
            if (Math.abs(NorthstarPlanets.eris_x + this.scrollX + 7.0 - mouseX) < 8.0 && Math.abs(NorthstarPlanets.eris_y + this.scrollY + 7.0 - mouseY) < 8.0) {
                this.selectedPlanet = "eris";
            }
        }
        return super.m_6375_(mouseX, mouseY, pButton);
    }

    public void scroll(double pDragX, double pDragY) {
        this.scrollX = Mth.m_14008_((double)(this.scrollX + pDragX), (double)0.0, (double)900.0);
        this.scrollY = Mth.m_14008_((double)(this.scrollY + pDragY), (double)0.0, (double)900.0);
    }

    public ResourceLocation getPlanetSprite(String planet) {
        return switch (planet) {
            case "mercury" -> MERCURY;
            case "venus" -> VENUS;
            case "earth" -> EARTH;
            case "earth_moon", "moon" -> MOON;
            case "mars" -> MARS;
            case "ceres" -> CERES;
            case "jupiter" -> JUPITER;
            case "saturn" -> SATURN;
            case "uranus" -> URANUS;
            case "neptune" -> NEPTUNE;
            case "pluto" -> PLUTO;
            case "eris" -> ERIS;
            default -> null;
        };
    }

    public Component getPlanetName(String planet) {
        return Component.m_237115_((String)("planets." + planet + ".name"));
    }
}

