/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.temperature_regulator;

import com.lightning.northstar.block.tech.temperature_regulator.MovingTemperatureRegulator;
import com.lightning.northstar.block.tech.temperature_regulator.TemperatureRegulatorBlockEntity;
import com.lightning.northstar.content.NorthstarPackets;
import com.lightning.northstar.contraption.ActorConfigPacket;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.AdventureUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.MutablePair;

public class TemperatureRegulatorEditPacket
extends SimplePacketBase {
    private final int contraptionId;
    private final BlockPos pos;
    private final int temperature;
    private final boolean limit;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;

    public TemperatureRegulatorEditPacket(FriendlyByteBuf buffer) {
        this.contraptionId = buffer.m_130242_();
        this.pos = buffer.m_130135_();
        this.temperature = Mth.m_14045_((int)buffer.m_130242_(), (int)-273, (int)1500);
        this.limit = buffer.readBoolean();
        this.sizeX = TemperatureRegulatorEditPacket.clampSize(buffer.m_130242_());
        this.sizeY = TemperatureRegulatorEditPacket.clampSize(buffer.m_130242_());
        this.sizeZ = TemperatureRegulatorEditPacket.clampSize(buffer.m_130242_());
    }

    public TemperatureRegulatorEditPacket(int contraptionId, BlockPos pos, int temperature, boolean limit, int sizeX, int sizeY, int sizeZ) {
        this.contraptionId = contraptionId;
        this.pos = pos;
        this.temperature = temperature;
        this.limit = limit;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.contraptionId);
        buffer.m_130064_(this.pos);
        buffer.m_130130_(this.temperature);
        buffer.writeBoolean(this.limit);
        buffer.m_130130_(this.sizeX);
        buffer.m_130130_(this.sizeY);
        buffer.m_130130_(this.sizeZ);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || player.m_5833_() || AdventureUtil.isAdventure((Player)player)) {
                return;
            }
            Level world = player.m_9236_();
            Entity patt2880$temp = world.m_6815_(this.contraptionId);
            if (patt2880$temp instanceof AbstractContraptionEntity) {
                AbstractContraptionEntity entity = (AbstractContraptionEntity)patt2880$temp;
                this.handleContraption(player, entity);
            } else {
                this.handleWorld(player, world);
            }
        });
        return true;
    }

    private void handleContraption(ServerPlayer player, AbstractContraptionEntity entity) {
        MutablePair actor = entity.getContraption().getActorAt(this.pos);
        if (actor == null) {
            return;
        }
        Object object = ((MovementContext)actor.right).temporaryData;
        if (!(object instanceof MovingTemperatureRegulator)) {
            return;
        }
        MovingTemperatureRegulator regulator = (MovingTemperatureRegulator)object;
        BlockPos localPos = regulator.context.localPos;
        if (!entity.toGlobalVector(Vec3.m_82539_((Vec3i)localPos), 0.0f).m_82509_((Position)player.m_20182_(), 20.0)) {
            return;
        }
        regulator.regulator.temperature = this.temperature;
        regulator.regulator.setBounds((Vec3i)localPos, this.limit, this.sizeX, this.sizeY, this.sizeZ);
        CompoundTag nbt = ((StructureTemplate.StructureBlockInfo)actor.left).f_74677_() == null ? new CompoundTag() : ((StructureTemplate.StructureBlockInfo)actor.left).f_74677_().m_6426_();
        regulator.regulator.write(nbt);
        actor.left = new StructureTemplate.StructureBlockInfo(localPos, ((StructureTemplate.StructureBlockInfo)actor.left).f_74676_(), nbt);
        entity.setBlock(localPos, (StructureTemplate.StructureBlockInfo)actor.left);
        NorthstarPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ActorConfigPacket(entity.m_19879_(), localPos, nbt));
    }

    private void handleWorld(ServerPlayer player, Level world) {
        if (!world.m_46749_(this.pos) || !this.pos.m_123314_((Vec3i)player.m_20183_(), 20.0)) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(this.pos);
        if (blockEntity instanceof TemperatureRegulatorBlockEntity) {
            TemperatureRegulatorBlockEntity be = (TemperatureRegulatorBlockEntity)blockEntity;
            be.regulator.temperature = this.temperature;
            be.regulator.setBounds((Vec3i)be.m_58899_(), this.limit, this.sizeX, this.sizeY, this.sizeZ);
            be.sendData();
            be.m_6596_();
        }
    }

    private static int clampSize(int size) {
        return Mth.m_14045_((int)size, (int)1, (int)5);
    }
}

