/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VenusMimicEntity
extends Monster
implements GeoAnimatable {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.2, AttributeModifier.Operation.ADDITION);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int attackTick;
    private int hideTick;
    private int ignoreHideTimer = 0;
    private int aggroTimer = 0;
    private boolean hiding = false;
    private boolean attacking = false;
    public boolean isDeep;
    public boolean deepCheck;

    public VenusMimicEntity(EntityType<? extends VenusMimicEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    private PlayState predicate(AnimationState<VenusMimicEntity> event) {
        AnimationController controller = event.getController();
        if (this.attackTick > 0) {
            --this.attackTick;
            controller.setAnimation(RawAnimation.begin().then("mimic_bite", Animation.LoopType.PLAY_ONCE));
        } else if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.attacking)) {
            controller.setAnimation(RawAnimation.begin().thenLoop("mimic_walk"));
        } else if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || !this.attacking)) {
            controller.setAnimation(RawAnimation.begin().thenLoop("mimic_run"));
        } else if (this.hiding && this.hideTick > 0) {
            controller.setAnimation(RawAnimation.begin().thenLoop("mimic_hide"));
        } else if (this.hiding) {
            controller.setAnimation(RawAnimation.begin().thenLoop("mimic_hide_idle"));
        } else {
            controller.setAnimation(RawAnimation.begin().thenLoop("mimic_idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public static boolean mimicSpawnRules(EntityType<VenusMimicEntity> cobra, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        BlockState state = level.m_8055_(pos.m_7495_());
        return state.m_204336_(NorthstarTags.NorthstarBlockTags.NATURAL_VENUS_BLOCKS.tag) && !level.m_45527_(pos);
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.attackTick = 40;
        } else if (pId == 8) {
            this.hiding = true;
            this.hideTick = 12;
        } else if (pId == 9) {
            this.hiding = false;
            this.ignoreHideTimer = 1200;
        } else if (pId == 12) {
            this.attacking = true;
        } else if (pId == 13) {
            this.attacking = false;
        } else {
            super.m_7822_(pId);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.deepCheck) {
            if (this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_((Block)NorthstarBlocks.VENUS_DEEP_STONE.get()) || this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_((Block)AllPaletteStoneTypes.SCORCHIA.getBaseBlock().get())) {
                this.isDeep = true;
            }
            this.deepCheck = true;
        }
        if (this.m_5448_() != null) {
            if (this.m_20270_((Entity)this.m_5448_()) < 5.0f) {
                if (this.aggroTimer > 100) {
                    this.hiding = false;
                    this.ignoreHideTimer = 500;
                    this.m_9236_().m_7605_((Entity)this, (byte)9);
                    this.f_21346_.m_25374_(Goal.Flag.MOVE);
                    this.f_21346_.m_25374_(Goal.Flag.LOOK);
                    this.f_21346_.m_25374_(Goal.Flag.JUMP);
                }
                ++this.aggroTimer;
            } else {
                --this.aggroTimer;
            }
        }
        if (this.m_9236_().f_46441_.m_188503_(250) == 0 && this.m_5448_() == null && !this.hiding && !this.m_9236_().f_46443_ && this.ignoreHideTimer <= 0) {
            this.m_9236_().m_7605_((Entity)this, (byte)8);
            this.hiding = true;
            this.hideTick = 12;
            this.m_146926_(Mth.m_144941_((int)((int)this.m_146909_()), (int)90));
        }
        if (this.hiding && this.m_9236_().f_46441_.m_188503_(2000) == 0 && !this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)9);
            this.ignoreHideTimer = 100;
            this.hiding = false;
        }
        if (this.hiding && !this.m_9236_().f_46443_ && this.m_5448_() != null) {
            this.f_21346_.m_25355_(Goal.Flag.MOVE);
            this.f_21346_.m_25355_(Goal.Flag.LOOK);
            this.f_21346_.m_25355_(Goal.Flag.JUMP);
            this.m_21573_().m_26573_();
            if (this.hideTick == 12) {
                // empty if block
            }
            this.m_5618_(0.0f);
            this.m_5616_(0.0f);
            --this.hideTick;
        } else if (this.hiding && this.m_9236_().f_46443_) {
            this.f_21346_.m_25355_(Goal.Flag.MOVE);
            this.f_21346_.m_25355_(Goal.Flag.LOOK);
            this.f_21346_.m_25355_(Goal.Flag.JUMP);
            this.m_21573_().m_26573_();
            this.m_5618_(0.0f);
            this.m_5616_(0.0f);
            --this.hideTick;
        }
        if (!this.hiding) {
            if (this.ignoreHideTimer > 0) {
                this.ignoreHideTimer = Mth.m_14045_((int)this.ignoreHideTimer, (int)0, (int)(this.ignoreHideTimer - 1));
            }
            this.f_21346_.m_25374_(Goal.Flag.MOVE);
            this.f_21346_.m_25374_(Goal.Flag.LOOK);
            this.f_21346_.m_25374_(Goal.Flag.JUMP);
        }
    }

    protected void m_8024_() {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_5448_() != null && !this.hiding) {
            if (!attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
                this.attacking = true;
                this.m_9236_().m_7605_((Entity)this, (byte)12);
            }
        } else if (attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
            this.attacking = false;
            this.m_9236_().m_7605_((Entity)this, (byte)13);
            attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        }
        super.m_8024_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        super.m_8099_();
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.hiding = false;
        this.ignoreHideTimer = 1200;
        this.m_9236_().m_7605_((Entity)this, (byte)9);
        this.m_5496_(SoundEvents.f_12357_, 1.0f, 1.0f);
        return super.m_7327_(pEntity);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("isDeep", this.isDeep);
        pCompound.m_128379_("deepCheck", this.deepCheck);
        pCompound.m_128379_("hiding", this.hiding);
        pCompound.m_128405_("aggroTimer", this.aggroTimer);
        pCompound.m_128405_("ignoreHideTimer", this.ignoreHideTimer);
        pCompound.m_128405_("hideTick", this.hideTick);
        pCompound.m_128405_("attackTick", this.attackTick);
        pCompound.m_128405_("tickCount", this.f_19797_);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("isDeep")) {
            this.isDeep = pCompound.m_128471_("isDeep");
        }
        if (pCompound.m_128441_("deepCheck")) {
            this.deepCheck = pCompound.m_128471_("deepCheck");
        }
        if (pCompound.m_128441_("hiding")) {
            this.hiding = pCompound.m_128471_("hiding");
        }
        if (pCompound.m_128441_("aggroTimer")) {
            this.aggroTimer = pCompound.m_128451_("aggroTimer");
        }
        if (pCompound.m_128441_("ignoreHideTimer")) {
            this.ignoreHideTimer = pCompound.m_128451_("ignoreHideTimer");
        }
        if (pCompound.m_128441_("hideTick")) {
            this.hideTick = pCompound.m_128451_("hideTick");
        }
        if (pCompound.m_128441_("attackTick")) {
            this.attackTick = pCompound.m_128451_("attackTick");
        }
        if (pCompound.m_128441_("tickCount")) {
            this.f_19797_ = pCompound.m_128451_("tickCount");
        }
    }

    protected SoundEvent m_7515_() {
        if (!this.hiding) {
            return (SoundEvent)NorthstarSounds.VENUS_MIMIC_IDLE.get();
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        super.m_7975_(pDamageSource);
        return (SoundEvent)NorthstarSounds.VENUS_MIMIC_HURT.get();
    }

    protected SoundEvent m_5592_() {
        super.m_5592_();
        return (SoundEvent)NorthstarSounds.VENUS_MIMIC_DEATH.get();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && this.hiding) {
            this.hiding = false;
            this.ignoreHideTimer = 1200;
            this.m_9236_().m_7605_((Entity)this, (byte)9);
        }
        return super.m_6469_(pSource, pAmount);
    }

    boolean isLookingAtMe(Player pPlayer) {
        ItemStack itemstack = (ItemStack)pPlayer.m_150109_().f_35975_.get(3);
        if (itemstack.m_150930_(Blocks.f_50143_.m_5456_())) {
            return false;
        }
        Vec3 vec3 = pPlayer.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - pPlayer.m_20185_(), this.m_20188_() - pPlayer.m_20188_(), this.m_20189_() - pPlayer.m_20189_());
        double d0 = vec31.m_82553_();
        vec31 = vec31.m_82541_();
        double d1 = vec3.m_82526_(vec31);
        Northstar.LOGGER.debug("{}", (Object)d1);
        Northstar.LOGGER.debug("comparer: {}", (Object)(1.0 - 0.35 / (d0 / 8.0)));
        return d1 > 1.0 - 0.35 / (d0 / 8.0) ? pPlayer.m_142582_((Entity)this) : false;
    }

    boolean canTarget(LivingEntity target) {
        if (!this.m_6779_(target)) {
            return false;
        }
        return target.m_6095_() == EntityType.f_20532_;
    }

    static class MimicLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final VenusMimicEntity mimic;
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int stareTimer;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

        public MimicLookForPlayerGoal(VenusMimicEntity coberuh, @Nullable Predicate<LivingEntity> pSelectionPredicate) {
            super((Mob)coberuh, Player.class, 10, false, false, pSelectionPredicate);
            this.mimic = coberuh;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(p_32578_ -> coberuh.isLookingAtMe((Player)p_32578_));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.mimic.m_9236_().m_45946_(this.startAggroTargetConditions, (LivingEntity)this.mimic);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = this.m_183277_(5);
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.mimic.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.stareTimer = Mth.m_14045_((int)(this.stareTimer + 1), (int)0, (int)120);
                Northstar.LOGGER.debug("{}", (Object)this.stareTimer);
                if (this.stareTimer >= 32) {
                    this.mimic.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                    return true;
                }
                return false;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.mimic, this.f_26050_) ? true : super.m_8045_();
        }

        public void m_8037_() {
            if (this.mimic.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (!this.mimic.isLookingAtMe(this.pendingTarget)) {
                    this.stareTimer = Mth.m_14045_((int)this.stareTimer, (int)0, (int)(this.stareTimer - 1));
                    Northstar.LOGGER.debug("{}", (Object)this.stareTimer);
                }
                if (--this.aggroTime <= 0) {
                    if (!this.mimic.hiding) {
                        this.mimic.hiding = true;
                        this.mimic.hideTick = 12;
                        this.mimic.m_9236_().m_7605_((Entity)this.mimic, (byte)8);
                    }
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            }
            super.m_8037_();
        }
    }

    static class HideWhenStaredAt
    extends Goal {
        private final VenusMimicEntity mimic;
        @Nullable
        private LivingEntity target;

        public HideWhenStaredAt(VenusMimicEntity mimiece) {
            this.mimic = mimiece;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.mimic.m_5448_();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.m_20280_((Entity)this.mimic);
            return !(d0 > 256.0) && this.mimic.isLookingAtMe((Player)this.target) && d0 > 5.0;
        }

        public void m_8056_() {
            this.mimic.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.mimic.m_21563_().m_24946_(this.mimic.m_20185_() + 20.0, this.mimic.m_20186_(), this.mimic.m_20189_() + 20.0);
        }
    }
}

