/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.entity.goals.ChargeAtTargetGoal;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VenusStoneBullEntity
extends Monster
implements GeoAnimatable {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.2, AttributeModifier.Operation.ADDITION);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public boolean charging = false;
    public boolean passedTarget = false;
    public int stopChargeTimer = 0;
    public int chargeTimer = 0;
    public int chargeCooldown = 0;
    public BlockPos targetPos;
    public int ticksSpentCharging = 0;
    public Vec3 moveDirection;

    public VenusStoneBullEntity(EntityType<? extends VenusStoneBullEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    private PlayState predicate(AnimationState<VenusStoneBullEntity> event) {
        AnimationController controller = event.getController();
        if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.charging)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || !this.charging || this.passedTarget)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("charge"));
        } else if ((!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) && this.charging && this.passedTarget) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.venus_stone_bull.stop_charge"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public static boolean stoneBullSpawnRules(EntityType<VenusStoneBullEntity> moth, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        BlockState state = level.m_8055_(pos.m_7495_());
        return state.m_204336_(NorthstarTags.NorthstarBlockTags.NATURAL_VENUS_BLOCKS.tag);
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            // empty if block
        }
        if (pId == 63) {
            this.charging = true;
        }
        if (pId == 65) {
            this.charging = false;
        }
        if (pId == 66) {
            this.passedTarget = true;
        }
        if (pId == 67) {
            this.charging = false;
            this.passedTarget = false;
        }
        super.m_7822_(pId);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.charging && this.passedTarget && !this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60795_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * (float)(this.f_19796_.m_188499_() ? -1 : 1)), this.m_20186_(), this.m_20189_() + (double)(this.f_19796_.m_188501_() * (float)(this.f_19796_.m_188499_() ? -1 : 1)), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * (float)(this.f_19796_.m_188499_() ? -1 : 1)), this.m_20186_(), this.m_20189_() + (double)(this.f_19796_.m_188501_() * (float)(this.f_19796_.m_188499_() ? -1 : 1)), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * (float)(this.f_19796_.m_188499_() ? -1 : 1)), this.m_20186_(), this.m_20189_() + (double)(this.f_19796_.m_188501_() * (float)(this.f_19796_.m_188499_() ? -1 : 1)), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * (float)(this.f_19796_.m_188499_() ? -1 : 1)), this.m_20186_(), this.m_20189_() + (double)(this.f_19796_.m_188501_() * (float)(this.f_19796_.m_188499_() ? -1 : 1)), 0.0, 0.0, 0.0);
        }
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
            Northstar.LOGGER.debug("target: {}, charging: {}, chargeTime: {}", new Object[]{this.m_5448_(), this.charging, this.chargeTimer});
        }
    }

    protected void m_8024_() {
        if (this.chargeTimer > 0) {
            this.chargeTimer = Mth.m_14045_((int)this.chargeTimer, (int)0, (int)(this.chargeTimer - 1));
        }
        if (this.stopChargeTimer > 0) {
            this.stopChargeTimer = Mth.m_14045_((int)this.stopChargeTimer, (int)0, (int)(this.stopChargeTimer - 1));
        }
        if (this.chargeCooldown > 0) {
            this.chargeCooldown = Mth.m_14045_((int)this.chargeCooldown, (int)0, (int)(this.chargeCooldown - 1));
        }
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_5448_() != null) {
            if (!attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        } else if (attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
            attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        }
        super.m_8024_();
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return (SoundEvent)NorthstarSounds.VENUS_STONE_BULL_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.VENUS_STONE_BULL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)NorthstarSounds.VENUS_STONE_BULL_DEATH.get();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new ChargeAtTargetGoal(this, 1.5, 16));
        this.f_21345_.m_25352_(9, (Goal)new StareAtTargetGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombifiedPiglin.class, true));
        super.m_8099_();
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_((SoundEvent)NorthstarSounds.VENUS_STONE_BULL_ATTACK.get(), 1.0f, 1.0f);
        pEntity.m_20334_(pEntity.m_20184_().f_82479_ + this.m_20184_().f_82479_ / 4.0, pEntity.m_20184_().f_82480_ + 1.0, pEntity.m_20184_().f_82481_ + this.m_20184_().f_82481_ / 4.0);
        return super.m_7327_(pEntity);
    }

    static class StareAtTargetGoal
    extends Goal {
        private final VenusStoneBullEntity starer;

        public StareAtTargetGoal(VenusStoneBullEntity pShooter) {
            this.starer = pShooter;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.starer.charging) {
                return;
            }
            if (this.starer.m_5448_() == null) {
                Vec3 vec3 = this.starer.m_20184_();
                this.starer.m_146922_(-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f);
                this.starer.f_20883_ = this.starer.m_146908_();
            } else {
                LivingEntity livingentity = this.starer.m_5448_();
                if (livingentity.m_20280_((Entity)this.starer) < 4096.0) {
                    double d1 = livingentity.m_20185_() - this.starer.m_20185_();
                    double d2 = livingentity.m_20189_() - this.starer.m_20189_();
                    this.starer.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.starer.f_20883_ = this.starer.m_146908_();
                }
            }
        }
    }
}

