/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity.goals;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.entity.VenusStoneBullEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;

public class ChargeAtTargetGoal
extends MoveToBlockGoal {
    private final VenusStoneBullEntity chargingMob;
    private int ticksSinceReachedGoal;

    public ChargeAtTargetGoal(VenusStoneBullEntity mob, double pSpeedModifier, int pSearchRange) {
        super((PathfinderMob)mob, pSpeedModifier, 24, pSearchRange);
        this.chargingMob = mob;
    }

    public double m_8052_() {
        return 0.5;
    }

    public boolean m_8036_() {
        if (this.chargingMob.chargeCooldown > 0) {
            return false;
        }
        if (this.chargingMob.chargeTimer > 0) {
            return true;
        }
        if (this.searchForTarget()) {
            this.f_25600_ = ChargeAtTargetGoal.m_186073_((int)20);
            this.chargingMob.charging = true;
            this.chargingMob.m_9236_().m_7605_((Entity)this.chargingMob, (byte)63);
            return true;
        }
        this.f_25600_ = this.m_6099_(this.f_25598_);
        this.chargingMob.moveDirection = null;
        this.chargingMob.m_9236_().m_7605_((Entity)this.chargingMob, (byte)65);
        this.chargingMob.charging = false;
        return false;
    }

    private boolean searchForTarget() {
        if (this.chargingMob.m_5448_() == null) {
            return false;
        }
        BlockPos targetPos = this.chargingMob.m_5448_().m_20183_();
        BlockPos subPos = targetPos.m_121996_((Vec3i)this.chargingMob.m_20183_());
        double newX = subPos.m_123341_();
        double newZ = subPos.m_123343_();
        targetPos = this.chargingMob.m_20183_();
        if (this.chargingMob.moveDirection == null || this.chargingMob.moveDirection == Vec3.f_82478_) {
            this.chargingMob.moveDirection = new Vec3(newX, 0.0, newZ);
            Northstar.LOGGER.debug("DOING THINGS!!!!!!");
            this.chargingMob.ticksSpentCharging = 0;
            this.chargingMob.m_5496_((SoundEvent)NorthstarSounds.VENUS_STONE_BULL_CHARGE.get(), 1.0f, 1.0f);
            this.chargingMob.chargeTimer = 150;
            this.chargingMob.targetPos = this.chargingMob.m_5448_().m_20183_();
        }
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.ticksSinceReachedGoal = 0;
    }

    public void playDestroyProgressSound(LevelAccessor pLevel, BlockPos pPos) {
    }

    public void playBreakSound(Level pLevel, BlockPos pPos) {
    }

    public void m_8037_() {
        if (this.chargingMob.ticksSpentCharging > 60) {
            this.chargingMob.moveDirection = Vec3.f_82478_;
            this.chargingMob.targetPos = null;
            this.chargingMob.chargeTimer = 0;
            this.chargingMob.stopChargeTimer = 0;
            this.chargingMob.charging = false;
            this.chargingMob.m_9236_().m_7605_((Entity)this.chargingMob, (byte)67);
            this.chargingMob.passedTarget = false;
            this.chargingMob.chargeCooldown = 200;
            this.chargingMob.ticksSpentCharging = 0;
            this.m_8041_();
            return;
        }
        this.chargingMob.m_21573_().m_26573_();
        super.m_8037_();
        if (this.chargingMob.chargeTimer != 0) {
            this.m_8041_();
        }
        Northstar.LOGGER.debug("targetPos: {}", (Object)this.chargingMob.targetPos);
        Northstar.LOGGER.debug("blockPos: {}", (Object)this.chargingMob.m_20183_());
        Northstar.LOGGER.debug("moveDirection: {}", (Object)this.chargingMob.moveDirection);
        Northstar.LOGGER.debug("target: {}", (Object)this.chargingMob.m_5448_());
        if (this.chargingMob.targetPos != null && this.chargingMob.m_20183_() != null && this.chargingMob.moveDirection != null) {
            LivingEntity livingentity;
            Vec3 targetVec = this.blockPosToVec3(this.chargingMob.targetPos);
            Vec3 chargerVec = this.blockPosToVec3(this.chargingMob.m_20183_());
            Vec3 subVec = targetVec.m_82546_(chargerVec);
            Northstar.LOGGER.debug("SUBVEC: {}", (Object)subVec);
            for (Entity colliders : this.chargingMob.m_9236_().m_45933_((Entity)this.chargingMob, this.chargingMob.m_20191_())) {
                if (!(colliders instanceof LivingEntity)) continue;
                LivingEntity lc = (LivingEntity)colliders;
                Vec3 vec = lc.m_20184_();
                lc.m_6469_(lc.m_9236_().m_269111_().m_269354_(), 5.0f);
                this.chargingMob.m_5496_((SoundEvent)NorthstarSounds.VENUS_STONE_BULL_ATTACK.get(), 1.0f, 1.0f);
                if (this.chargingMob.moveDirection == null) continue;
                lc.m_20334_(vec.f_82479_ + this.chargingMob.moveDirection.f_82479_ / 50.0, vec.f_82480_ + 0.3, vec.f_82481_ + this.chargingMob.moveDirection.f_82481_ / 50.0);
            }
            boolean xFlag = false;
            boolean zFlag = false;
            if (this.chargingMob.moveDirection.f_82479_ > 0.0) {
                boolean bl = xFlag = subVec.f_82479_ < 0.0;
            }
            if (this.chargingMob.moveDirection.f_82479_ < 0.0) {
                boolean bl = xFlag = subVec.f_82479_ > 0.0;
            }
            if (this.chargingMob.moveDirection.f_82481_ > 0.0) {
                boolean bl = zFlag = subVec.f_82481_ < 0.0;
            }
            if (this.chargingMob.moveDirection.f_82481_ < 0.0) {
                boolean bl = zFlag = subVec.f_82481_ > 0.0;
            }
            if (xFlag && zFlag && !this.chargingMob.passedTarget && !this.chargingMob.passedTarget) {
                this.chargingMob.passedTarget = true;
                this.chargingMob.m_9236_().m_7605_((Entity)this.chargingMob, (byte)66);
            }
            if (this.blockPosToVec3(this.chargingMob.m_20183_()).m_82554_(this.blockPosToVec3(this.chargingMob.targetPos)) > 15.0) {
                this.m_8041_();
                this.chargingMob.moveDirection = Vec3.f_82478_;
                this.chargingMob.targetPos = null;
                this.chargingMob.chargeTimer = 0;
                this.chargingMob.stopChargeTimer = 0;
                this.chargingMob.charging = false;
                this.chargingMob.m_9236_().m_7605_((Entity)this.chargingMob, (byte)67);
                this.chargingMob.passedTarget = false;
                this.chargingMob.chargeCooldown = 200;
                this.chargingMob.ticksSpentCharging = 0;
                this.m_8041_();
                return;
            }
            if (!this.chargingMob.passedTarget && this.chargingMob.m_5448_() != null && (livingentity = this.chargingMob.m_5448_()).m_20280_((Entity)this.chargingMob) < 4096.0) {
                double d1 = livingentity.m_20185_() - this.chargingMob.m_20185_();
                double d2 = livingentity.m_20189_() - this.chargingMob.m_20189_();
                this.chargingMob.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                this.chargingMob.f_20883_ = this.chargingMob.m_146908_();
            }
            Vec3 vec = this.chargingMob.m_20184_();
            vec = vec.m_82520_(this.chargingMob.moveDirection.f_82479_, 0.0, this.chargingMob.moveDirection.f_82481_);
            this.chargingMob.f_20883_ = this.chargingMob.m_146908_();
            ++this.chargingMob.ticksSpentCharging;
            Vec3 delta = this.chargingMob.m_20184_();
            if (!this.chargingMob.passedTarget) {
                this.chargingMob.m_20334_(delta.f_82479_ + this.chargingMob.moveDirection.f_82479_ / 50.0, delta.f_82480_ + this.chargingMob.moveDirection.f_82480_ / 50.0, delta.f_82481_ + this.chargingMob.moveDirection.f_82481_ / 50.0);
            } else {
                this.chargingMob.m_20334_(delta.f_82479_ + this.chargingMob.moveDirection.f_82479_ / 50.0 * 0.7, delta.f_82480_ + this.chargingMob.moveDirection.f_82480_ / 50.0 * 0.7, delta.f_82481_ + this.chargingMob.moveDirection.f_82481_ / 50.0 * 0.7);
                ++this.ticksSinceReachedGoal;
            }
        }
    }

    public Vec3 blockPosToVec3(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public boolean m_8045_() {
        return this.chargingMob.moveDirection != null && this.chargingMob.targetPos != null;
    }

    protected void m_25624_() {
    }

    protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
        ChunkAccess chunkaccess = pLevel.m_6522_(SectionPos.m_123171_((int)pPos.m_123341_()), SectionPos.m_123171_((int)pPos.m_123343_()), ChunkStatus.f_62326_, false);
        return chunkaccess != null;
    }
}

