/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.particle;

import com.lightning.northstar.particle.ColdAirParticle;
import com.lightning.northstar.particle.NorthstarParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ColdAirParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<ColdAirParticleData> {
    public static final Codec<ColdAirParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("x").forGetter(p -> p.posX), (App)Codec.INT.fieldOf("y").forGetter(p -> p.posY), (App)Codec.INT.fieldOf("z").forGetter(p -> p.posZ)).apply((Applicative)i, ColdAirParticleData::new));
    public static final ParticleOptions.Deserializer<ColdAirParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ColdAirParticleData>(){

        public ColdAirParticleData fromCommand(ParticleType<ColdAirParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int x = reader.readInt();
            reader.expect(' ');
            int y = reader.readInt();
            reader.expect(' ');
            int z = reader.readInt();
            return new ColdAirParticleData(x, y, z);
        }

        public ColdAirParticleData fromNetwork(ParticleType<ColdAirParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new ColdAirParticleData(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
    };
    final int posX;
    final int posY;
    final int posZ;

    public ColdAirParticleData(Vec3i pos) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public ColdAirParticleData(int posX, int posY, int posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public ColdAirParticleData() {
        this(0, 0, 0);
    }

    public ParticleType<?> m_6012_() {
        return NorthstarParticles.COLD_AIR.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.posX);
        buffer.writeInt(this.posY);
        buffer.writeInt(this.posZ);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d %d", NorthstarParticles.COLD_AIR.parameter(), this.posX, this.posY, this.posZ);
    }

    public ParticleOptions.Deserializer<ColdAirParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    public Codec<ColdAirParticleData> getCodec(ParticleType<ColdAirParticleData> type) {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleEngine.SpriteParticleRegistration<ColdAirParticleData> getMetaFactory() {
        return ColdAirParticle.Factory::new;
    }
}

