/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world;

import com.lightning.northstar.block.tech.oxygen_sealer.OxygenSealerBlockEntity;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.world.SealingProvider;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="northstar", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class NorthstarOxygen {
    public static final int MAXIMUM_OXYGEN = 1800;
    private final Level level;
    private final Set<SealingProvider> providers;

    public NorthstarOxygen(Level level) {
        this.level = level;
        this.providers = new HashSet<SealingProvider>();
    }

    public boolean hasOxygen(Vec3 pos) {
        if (NorthstarPlanets.getPlanetOxy((ResourceKey<Level>)this.level.m_46472_())) {
            return true;
        }
        for (SealingProvider sealer : this.providers) {
            if (!sealer.isSealed(pos)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOxygen(Vec3i pos) {
        if (NorthstarPlanets.getPlanetOxy((ResourceKey<Level>)this.level.m_46472_())) {
            return true;
        }
        for (SealingProvider sealer : this.providers) {
            if (!sealer.isSealed(pos)) continue;
            return true;
        }
        return false;
    }

    public void registerSealer(SealingProvider provider) {
        this.providers.add(provider);
    }

    public void unregisterSealer(SealingProvider provider) {
        this.providers.remove(provider);
    }

    public static boolean isOxygen(Fluid fluid) {
        return NorthstarTags.NorthstarFluidTags.C_OXYGEN.matches(fluid) || NorthstarTags.NorthstarFluidTags.IS_OXY.matches(fluid);
    }

    public static boolean hasOxygen(Level level, Vec3 pos) {
        return level.northstar$oxygen().hasOxygen(pos);
    }

    public static boolean hasOxygen(Level level, Vec3i pos) {
        return level.northstar$oxygen().hasOxygen(pos);
    }

    public static NorthstarOxygen getDimension(Level level) {
        return level.northstar$oxygen();
    }

    public static ItemStack getOxy(LivingEntity entity) {
        for (ItemStack items : entity.m_6168_()) {
            if (!items.m_204117_(NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.tag)) continue;
            return items;
        }
        return ItemStack.f_41583_;
    }

    @ApiStatus.Internal
    public static void tickEntity(LivingEntity entity) {
        Player player;
        Level world = entity.m_9236_();
        if (world.m_46467_() % 20L != (long)(entity.m_19879_() % 20)) {
            return;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            return;
        }
        if (NorthstarTags.NorthstarEntityTags.DOESNT_REQUIRE_OXYGEN.matches((Entity)entity)) {
            return;
        }
        if (NorthstarOxygen.hasOxygen(entity.m_9236_(), entity.m_146892_())) {
            return;
        }
        boolean isFullyCovered = true;
        ItemStack oxygenSource = ItemStack.f_41583_;
        for (ItemStack armor : entity.m_6168_()) {
            if (armor.m_41619_()) {
                isFullyCovered = false;
                break;
            }
            if (!NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.matches(armor)) continue;
            oxygenSource = armor;
        }
        if (!isFullyCovered || oxygenSource.m_41619_() || !NorthstarOxygen.depleteOxygen(oxygenSource)) {
            entity.m_6469_(world.m_269111_().northstar$suffocation(), 1.0f);
        }
    }

    public static boolean depleteOxygen(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_("Oxygen", 3)) {
            return false;
        }
        int oxygen = tag.m_128451_("Oxygen");
        if (oxygen <= 0) {
            return false;
        }
        tag.m_128405_("Oxygen", Math.min(oxygen - 1, 1800));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPostRender(RenderLevelStageEvent event) {
        if (!((Boolean)NorthstarConfigs.client().debugSealerBounds.get()).booleanValue()) {
            return;
        }
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            PoseStack pose = event.getPoseStack();
            Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            pose.m_85836_();
            pose.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
            for (SealingProvider provider : NorthstarOxygen.getDimension((Level)Minecraft.m_91087_().f_91073_).providers) {
                if (!(provider instanceof OxygenSealerBlockEntity)) continue;
                OxygenSealerBlockEntity sealer = (OxygenSealerBlockEntity)provider;
                sealer.getSealer().getVisualizer().render(pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_());
            }
            pose.m_85849_();
        }
    }
}

