/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features;

import com.lightning.northstar.world.features.configuration.StoneColumnConfiguration;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StoneColumnFeature
extends Feature<StoneColumnConfiguration> {
    public StoneColumnFeature(Codec<StoneColumnConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<StoneColumnConfiguration> pContext) {
        Object t;
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        BlockPos blockpos = pContext.m_159777_();
        StoneColumnConfiguration largedripstoneconfiguration = (StoneColumnConfiguration)pContext.m_159778_();
        RandomSource randomsource = pContext.m_225041_();
        if (!StoneColumnFeature.isEmptyOrWater((LevelAccessor)worldgenlevel, blockpos)) {
            return false;
        }
        Optional optional = Column.m_158175_((LevelSimulatedReader)worldgenlevel, (BlockPos)blockpos, (int)largedripstoneconfiguration.floorToCeilingSearchRange(), DripstoneUtils::m_159664_, DripstoneUtils::m_159649_);
        if (optional.isPresent() && (t = optional.get()) instanceof Column.Range) {
            Column.Range column$range = (Column.Range)t;
            if (column$range.m_158214_() < 4) {
                return false;
            }
            int i = (int)((float)column$range.m_158214_() * largedripstoneconfiguration.maxColumnRadiusToCaveHeightRatio());
            int j = Mth.m_14045_((int)i, (int)largedripstoneconfiguration.columnRadius().m_142739_(), (int)largedripstoneconfiguration.columnRadius().m_142737_());
            int k = Mth.m_216287_((RandomSource)randomsource, (int)largedripstoneconfiguration.columnRadius().m_142739_(), (int)j);
            LargeDripstone largedripstonefeature$largedripstone = StoneColumnFeature.makeDripstone(blockpos.m_175288_(column$range.m_158212_() - 1), false, randomsource, k, largedripstoneconfiguration.stalactiteBluntness(), largedripstoneconfiguration.heightScale());
            LargeDripstone largedripstonefeature$largedripstone1 = StoneColumnFeature.makeDripstone(blockpos.m_175288_(column$range.m_158213_() + 1), true, randomsource, k, largedripstoneconfiguration.stalagmiteBluntness(), largedripstoneconfiguration.heightScale());
            WindOffsetter largedripstonefeature$windoffsetter = largedripstonefeature$largedripstone.isSuitableForWind(largedripstoneconfiguration) && largedripstonefeature$largedripstone1.isSuitableForWind(largedripstoneconfiguration) ? new WindOffsetter(blockpos.m_123342_(), randomsource, largedripstoneconfiguration.windSpeed()) : WindOffsetter.noWind();
            boolean flag = largedripstonefeature$largedripstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            boolean flag1 = largedripstonefeature$largedripstone1.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            if (flag) {
                largedripstonefeature$largedripstone.placeBlocks(worldgenlevel, randomsource, largedripstonefeature$windoffsetter, (StoneColumnConfiguration)pContext.m_159778_());
            }
            if (flag1) {
                largedripstonefeature$largedripstone1.placeBlocks(worldgenlevel, randomsource, largedripstonefeature$windoffsetter, (StoneColumnConfiguration)pContext.m_159778_());
            }
            return true;
        }
        return false;
    }

    private static LargeDripstone makeDripstone(BlockPos pRoot, boolean pPointingUp, RandomSource pRandom, int pRadius, FloatProvider pBluntnessBase, FloatProvider pScaleBase) {
        return new LargeDripstone(pRoot, pPointingUp, pRadius, pBluntnessBase.m_214084_(pRandom), pScaleBase.m_214084_(pRandom));
    }

    private void placeDebugMarkers(WorldGenLevel pLevel, BlockPos pPos, Column.Range pRange, WindOffsetter pWindOffsetter) {
        pLevel.m_7731_(pWindOffsetter.offset(pPos.m_175288_(pRange.m_158212_() - 1)), Blocks.f_50090_.m_49966_(), 2);
        pLevel.m_7731_(pWindOffsetter.offset(pPos.m_175288_(pRange.m_158213_() + 1)), Blocks.f_50074_.m_49966_(), 2);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_175288_(pRange.m_158213_() + 2).m_122032_();
        while (blockpos$mutableblockpos.m_123342_() < pRange.m_158212_() - 1) {
            BlockPos blockpos = pWindOffsetter.offset((BlockPos)blockpos$mutableblockpos);
            if (StoneColumnFeature.isEmptyOrWater((LevelAccessor)pLevel, blockpos) || pLevel.m_8055_(blockpos).m_60713_(Blocks.f_152537_)) {
                pLevel.m_7731_(blockpos, Blocks.f_50318_.m_49966_(), 2);
            }
            blockpos$mutableblockpos.m_122173_(Direction.UP);
        }
    }

    protected static boolean isEmptyOrWater(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, StoneColumnFeature::isEmptyOrWater);
    }

    public static boolean isEmptyOrWater(BlockState p_159665_) {
        return p_159665_.m_60795_() || p_159665_.m_60713_(Blocks.f_49990_);
    }

    protected static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel pLevel, BlockPos pPos, int pRadius) {
        if (StoneColumnFeature.isEmptyOrWaterOrLava((LevelAccessor)pLevel, pPos)) {
            return false;
        }
        float f = 6.0f;
        float f1 = 6.0f / (float)pRadius;
        for (float f2 = 0.0f; f2 < (float)Math.PI * 2; f2 += f1) {
            int j;
            int i = (int)(Mth.m_14089_((float)f2) * (float)pRadius);
            if (!StoneColumnFeature.isEmptyOrWaterOrLava((LevelAccessor)pLevel, pPos.m_7918_(i, 0, j = (int)(Mth.m_14031_((float)f2) * (float)pRadius)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEmptyOrWaterOrLava(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, StoneColumnFeature::isEmptyOrWaterOrLava);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState p_159667_) {
        return p_159667_.m_60795_() || p_159667_.m_60713_(Blocks.f_49990_) || p_159667_.m_60713_(Blocks.f_49991_);
    }

    protected static double getDripstoneHeight(double pRadius, double pMaxRadius, double pScale, double pMinRadius) {
        if (pRadius < pMinRadius) {
            pRadius = pMinRadius;
        }
        double d0 = 0.384;
        double d1 = pRadius / pMaxRadius * 0.384;
        double d2 = 0.75 * Math.pow(d1, 1.3333333333333333);
        double d3 = Math.pow(d1, 0.6666666666666666);
        double d4 = 0.3333333333333333 * Math.log(d1);
        double d5 = pScale * (d2 - d3 - d4);
        d5 = Math.max(d5, 0.0);
        return d5 / 0.384 * pMaxRadius;
    }

    static final class LargeDripstone {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeDripstone(BlockPos pRoot, boolean pPointingUp, int pRadius, double pBluntness, double pScale) {
            this.root = pRoot;
            this.pointingUp = pPointingUp;
            this.radius = pRadius;
            this.bluntness = pBluntness;
            this.scale = pScale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.m_123342_() : this.root.m_123342_() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.m_123342_() : this.root.m_123342_() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel pLevel, WindOffsetter pWindOffsetter) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.m_122032_();
                int i = Math.min(10, this.getHeight());
                for (int j = 0; j < i; ++j) {
                    if (pLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60713_(Blocks.f_49991_)) {
                        return false;
                    }
                    if (StoneColumnFeature.isCircleMostlyEmbeddedInStone(pLevel, pWindOffsetter.offset((BlockPos)blockpos$mutableblockpos), this.radius)) {
                        this.root = blockpos$mutableblockpos;
                        return true;
                    }
                    blockpos$mutableblockpos.m_122173_(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float pRadius) {
            return (int)StoneColumnFeature.getDripstoneHeight(pRadius, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(WorldGenLevel pLevel, RandomSource pRandom, WindOffsetter pWindOffsetter, StoneColumnConfiguration config) {
            for (int i = -this.radius; i <= this.radius; ++i) {
                block1: for (int j = -this.radius; j <= this.radius; ++j) {
                    int k;
                    float f = Mth.m_14116_((float)(i * i + j * j));
                    if (f > (float)this.radius || (k = this.getHeightAtRadius(f)) <= 0) continue;
                    if ((double)pRandom.m_188501_() < 0.2) {
                        k = (int)((float)k * Mth.m_216283_((RandomSource)pRandom, (float)0.8f, (float)1.0f));
                    }
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.m_7918_(i, 0, j).m_122032_();
                    boolean flag = false;
                    int l = this.pointingUp ? pLevel.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, blockpos$mutableblockpos.m_123341_(), blockpos$mutableblockpos.m_123343_()) : Integer.MAX_VALUE;
                    for (int i1 = 0; i1 < k && blockpos$mutableblockpos.m_123342_() < l; ++i1) {
                        BlockPos blockpos = pWindOffsetter.offset((BlockPos)blockpos$mutableblockpos);
                        if (StoneColumnFeature.isEmptyOrWaterOrLava((LevelAccessor)pLevel, blockpos)) {
                            flag = true;
                            pLevel.m_7731_(blockpos, config.stoneProvider().m_213972_(pRandom, (BlockPos)blockpos$mutableblockpos), 2);
                        } else if (flag) continue block1;
                        blockpos$mutableblockpos.m_122173_(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        boolean isSuitableForWind(StoneColumnConfiguration pConfig) {
            return this.radius >= pConfig.minRadiusForWind() && this.bluntness >= (double)pConfig.minBluntnessForWind();
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3 windSpeed;

        WindOffsetter(int pOriginY, RandomSource pRandom, FloatProvider pMagnitude) {
            this.originY = pOriginY;
            float f = pMagnitude.m_214084_(pRandom);
            float f1 = Mth.m_216283_((RandomSource)pRandom, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new Vec3((double)(Mth.m_14089_((float)f1) * f), 0.0, (double)(Mth.m_14031_((float)f1) * f));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        BlockPos offset(BlockPos pPos) {
            if (this.windSpeed == null) {
                return pPos;
            }
            int i = this.originY - pPos.m_123342_();
            Vec3 vec3 = this.windSpeed.m_82490_((double)i);
            return pPos.m_7918_((int)vec3.f_82479_, 0, (int)vec3.f_82481_);
        }
    }
}

