/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features.trunkplacers;

import com.google.common.collect.Lists;
import com.lightning.northstar.content.NorthstarBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class RoofPlateTrunkPlacer
extends TrunkPlacer {
    public static final Codec<RoofPlateTrunkPlacer> CODEC = RecordCodecBuilder.create(i -> RoofPlateTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)i).and(i.group((App)BlockStateProvider.f_68747_.fieldOf("cap_provider").forGetter(p -> p.capProvider), (App)IntProvider.f_146533_.fieldOf("extra_branch_steps").forGetter(p -> p.extraBranchSteps), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("can_grow_through").forGetter(p -> p.canGrowThrough))).apply((Applicative)i, RoofPlateTrunkPlacer::new));
    public final BlockStateProvider capProvider;
    private final IntProvider extraBranchSteps;
    private final HolderSet<Block> canGrowThrough;
    private BlockPos pos;
    private Direction trunkDir;

    public RoofPlateTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, BlockStateProvider capProvider, IntProvider extraBranchSteps, HolderSet<Block> canGrowThrough) {
        super(baseHeight, heightRandA, heightRandB);
        this.capProvider = capProvider;
        this.extraBranchSteps = extraBranchSteps;
        this.canGrowThrough = canGrowThrough;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return TrunkPlacerType.f_70319_;
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        this.trunkDir = Direction.m_235672_((RandomSource)pRandom);
        Direction dir = Direction.m_235672_((RandomSource)pRandom);
        while (this.trunkDir == Direction.UP || this.trunkDir == Direction.DOWN) {
            this.trunkDir = dir = Direction.m_235672_((RandomSource)pRandom);
        }
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            int Xpos = pPos.m_123341_();
            int Zpos = pPos.m_123343_();
            int j = pPos.m_123342_() - i;
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j, Zpos), pConfig);
        }
        this.placeCap(pLevel, pBlockSetter, pRandom, pPos, pFreeTreeHeight, pConfig);
        return list;
    }

    public void placeColumn(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos origin, int Xoff, int Zoff, int height, TreeConfiguration pConfig) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        blockpos$mutableblockpos.m_142451_(origin.m_123341_());
        blockpos$mutableblockpos.m_142443_(origin.m_123343_());
        for (int i = 0; i < height; ++i) {
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(origin.m_123341_() - Xoff, origin.m_123342_() + i, origin.m_123343_() - Zoff), pConfig);
        }
    }

    public void placeCap(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos origin, int treeHeight, TreeConfiguration pConfig) {
        BlockPos.MutableBlockPos thing = new BlockPos.MutableBlockPos();
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                if (Mth.m_14040_((int)x) + Mth.m_14040_((int)z) == 4) continue;
                this.placeCapBlock(pLevel, pBlockSetter, pRandom, (BlockPos)thing.m_122178_(origin.m_123341_() + x, origin.m_123342_() - treeHeight, origin.m_123343_() + z), pConfig);
            }
        }
    }

    protected boolean m_226187_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig) {
        return this.m_226175_(pLevel, pBlockSetter, pRandom, pPos, pConfig, Function.identity());
    }

    protected boolean m_226175_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig, Function<BlockState, BlockState> pPropertySetter) {
        if (this.m_213554_(pLevel, pPos)) {
            pBlockSetter.accept(pPos, pPropertySetter.apply(pConfig.f_68185_.m_213972_(pRandom, pPos)));
            return true;
        }
        return false;
    }

    protected boolean placeShroomLight(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig) {
        return this.placeShroomLight2(pLevel, pBlockSetter, pRandom, pPos, pConfig, Function.identity());
    }

    protected boolean placeShroomLight2(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig, Function<BlockState, BlockState> pPropertySetter) {
        if (this.m_213554_(pLevel, pPos)) {
            pBlockSetter.accept(pPos, pPropertySetter.apply(Blocks.f_50701_.m_49966_()));
            return true;
        }
        return false;
    }

    protected boolean placeCapBlock(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig) {
        return this.placeCapBlock2(pLevel, pBlockSetter, pRandom, pPos, pConfig, Function.identity());
    }

    protected boolean placeCapBlock2(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig, Function<BlockState, BlockState> pPropertySetter) {
        if (this.m_213554_(pLevel, pPos)) {
            pBlockSetter.accept(pPos, pPropertySetter.apply(this.capProvider.m_213972_(pRandom, pPos)));
            return true;
        }
        return false;
    }

    protected boolean m_213554_(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, state -> state.m_60713_(Blocks.f_50016_) || state.m_60713_((Block)NorthstarBlocks.PLATE_FUNGUS.get()) || state.m_60713_((Block)NorthstarBlocks.VENUS_STONE.get()) || state.m_60713_((Block)NorthstarBlocks.VENUS_DEEP_STONE.get()));
    }
}

