/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features.trunkplacers;

import com.google.common.collect.Lists;
import com.lightning.northstar.Northstar;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class WilterTrunkPlacer
extends TrunkPlacer {
    public static final Codec<WilterTrunkPlacer> CODEC = RecordCodecBuilder.create(i -> WilterTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)i).and(i.group((App)IntProvider.f_146533_.fieldOf("extra_branch_steps").forGetter(p -> p.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(p -> Float.valueOf(p.placeBranchPerLogProbability)), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(p -> p.extraBranchLength), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).fieldOf("can_grow_through").forGetter(p -> p.canGrowThrough), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(p -> p.spinFactor))).apply((Applicative)i, WilterTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;
    private final HolderSet<Block> canGrowThrough;
    private final IntProvider spinFactor;
    private int trunkXOffset;
    private int trunkZOffset;
    private int Xadd;
    private int Zadd;
    private BlockPos pos;
    private Direction trunkDir;

    public WilterTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough, IntProvider spinFactor) {
        super(baseHeight, heightRandA, heightRandB);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
        this.spinFactor = spinFactor;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return TrunkPlacerType.f_70319_;
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        int j;
        int Zpos;
        int Xpos;
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        this.trunkDir = Direction.m_235672_((RandomSource)pRandom);
        Direction dir = Direction.m_235672_((RandomSource)pRandom);
        while (this.trunkDir == Direction.UP || this.trunkDir == Direction.DOWN) {
            this.trunkDir = dir = Direction.m_235672_((RandomSource)pRandom);
        }
        Northstar.LOGGER.debug("{}", (Object)pFreeTreeHeight);
        if (this.trunkDir == Direction.EAST) {
            this.Xadd = 1;
            this.Zadd = 0;
        } else if (this.trunkDir == Direction.WEST) {
            this.Xadd = -1;
            this.Zadd = 0;
        } else if (this.trunkDir == Direction.NORTH) {
            this.Xadd = 0;
            this.Zadd = 1;
        } else if (this.trunkDir == Direction.SOUTH) {
            this.Xadd = 0;
            this.Zadd = -1;
        }
        int curve_x = 0;
        int curve_z = 0;
        int x_offset = 0;
        int z_offset = 0;
        for (int i = 0; i < pFreeTreeHeight; ++i) {
            int tree_y_dist = pFreeTreeHeight / 2;
            if (i < pFreeTreeHeight / 3) {
                x_offset -= this.Xadd;
                z_offset -= this.Zadd;
            }
            if (i > pFreeTreeHeight / 2) {
                curve_x = (i - tree_y_dist) / 2;
                curve_z = (i - tree_y_dist) / 2;
            }
            if (curve_x < -1) {
                curve_x = 0;
            }
            curve_x *= this.Xadd;
            if (curve_z < -1) {
                curve_z = 0;
            }
            Northstar.LOGGER.debug("{}", (Object)curve_x);
            Xpos = pPos.m_123341_() + curve_x + x_offset;
            Zpos = pPos.m_123343_() + (curve_z *= this.Zadd) + z_offset;
            j = pPos.m_123342_() + i;
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j, Zpos), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j - 1, Zpos), pConfig);
            if (i < pFreeTreeHeight / 3) {
                this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos + 1, j, Zpos), pConfig);
                this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos - 1, j, Zpos), pConfig);
                this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j, Zpos + 1), pConfig);
                this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j, Zpos - 1), pConfig);
                this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos + 1, j - 1, Zpos), pConfig);
                this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos - 1, j - 1, Zpos), pConfig);
                this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j - 1, Zpos + 1), pConfig);
                this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j - 1, Zpos - 1), pConfig);
                this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos.m_122178_(Xpos - this.Xadd, j + 1, Zpos - this.Zadd), pConfig);
            }
            if (i != pFreeTreeHeight - 1) continue;
            this.trunkXOffset = curve_x + x_offset;
            this.trunkZOffset = curve_z + z_offset;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos2 = new BlockPos.MutableBlockPos();
        for (int i = 1; i < pFreeTreeHeight / 2; ++i) {
            if (i % 2 == 0 && i > pFreeTreeHeight / 3) {
                this.trunkXOffset += this.Xadd;
                this.trunkZOffset += this.Zadd;
            } else if (i < pFreeTreeHeight / 3) {
                this.trunkXOffset += this.Xadd;
                this.trunkZOffset += this.Zadd;
            }
            Xpos = pPos.m_123341_() + this.trunkXOffset;
            Zpos = pPos.m_123343_() + this.trunkZOffset;
            j = pPos.m_123342_() + (pFreeTreeHeight - i);
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.m_122178_(Xpos, j, Zpos), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.m_122178_(Xpos, j - 1, Zpos), pConfig);
            if (i == pFreeTreeHeight / 2 - 1) {
                list.add(new FoliagePlacer.FoliageAttachment((BlockPos)blockpos$mutableblockpos.m_122178_(Xpos, j, Zpos), 0, false));
                this.pos = new BlockPos(Xpos, j, Zpos);
                BiConsumer<BlockPos, BlockState> biconsumer = (a, b) -> {
                    a = this.pos;
                    b = Blocks.f_50701_.m_49966_();
                };
                this.placeLight(pLevel, biconsumer, pRandom, pFreeTreeHeight, pPos, pConfig);
            }
            if (i != 1) continue;
            this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos2.m_122178_(Xpos - this.Xadd, j, Zpos - this.Zadd), pConfig);
        }
        return list;
    }

    public List<FoliagePlacer.FoliageAttachment> placeLight(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos blockpos$mutableblockpos3 = new BlockPos.MutableBlockPos();
        this.placeShroomLight(pLevel, pBlockSetter, pRandom, (BlockPos)blockpos$mutableblockpos3.m_122178_(pPos.m_123341_(), pPos.m_123342_() + 12, pPos.m_123343_()), pConfig);
        return list;
    }

    protected boolean m_226187_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig) {
        return this.m_226175_(pLevel, pBlockSetter, pRandom, pPos, pConfig, Function.identity());
    }

    protected boolean m_226175_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig, Function<BlockState, BlockState> pPropertySetter) {
        if (this.m_213554_(pLevel, pPos)) {
            pBlockSetter.accept(pPos, pPropertySetter.apply(pConfig.f_68185_.m_213972_(pRandom, pPos)));
            return true;
        }
        return false;
    }

    protected boolean placeShroomLight(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig) {
        return this.placeShroomLight2(pLevel, pBlockSetter, pRandom, pPos, pConfig, Function.identity());
    }

    protected boolean placeShroomLight2(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, BlockPos pPos, TreeConfiguration pConfig, Function<BlockState, BlockState> pPropertySetter) {
        if (this.m_213554_(pLevel, pPos)) {
            pBlockSetter.accept(pPos, pPropertySetter.apply(pConfig.f_68185_.m_213972_(pRandom, pPos)));
            return true;
        }
        return false;
    }

    protected boolean m_213554_(LevelSimulatedReader pLevel, BlockPos pPos) {
        return super.m_213554_(pLevel, pPos) || pLevel.m_7433_(pPos, p -> p.m_204341_(this.canGrowThrough));
    }
}

