/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.block.simple.ClusterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;

public class BuddingCrystalBlock
extends AmethystBlock {
    public static final int GROWTH_CHANCE = 5;
    private static final Direction[] DIRECTIONS = Direction.values();
    private Block clusterBlock;
    private Block stage1Block;
    private Block stage2Block;
    private Block stage3Block;

    public BuddingCrystalBlock(BlockBehaviour.Properties pProperties, Block stage1, Block stage2, Block stage3, Block cluster) {
        super(pProperties);
        this.clusterBlock = cluster;
        this.stage1Block = stage1;
        this.stage2Block = stage2;
        this.stage3Block = stage3;
    }

    @Deprecated
    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.DESTROY;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.nextInt(5) == 0) {
            Direction direction = DIRECTIONS[pRandom.nextInt(DIRECTIONS.length)];
            BlockPos blockpos = pPos.relative(direction);
            BlockState blockstate = pLevel.getBlockState(blockpos);
            Block block = null;
            if (BuddingCrystalBlock.canClusterGrowAtState(blockstate)) {
                block = this.stage1Block;
            } else if (blockstate.is(this.stage1Block) && blockstate.getValue((Property)ClusterBlock.FACING) == direction) {
                block = this.stage2Block;
            } else if (blockstate.is(this.stage2Block) && blockstate.getValue((Property)ClusterBlock.FACING) == direction) {
                block = this.stage3Block;
            } else if (blockstate.is(this.stage3Block) && blockstate.getValue((Property)ClusterBlock.FACING) == direction) {
                block = this.clusterBlock;
            }
            if (block != null) {
                BlockState blockstate1 = (BlockState)((BlockState)block.defaultBlockState().setValue((Property)ClusterBlock.FACING, (Comparable)direction)).setValue((Property)ClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate.getFluidState().getType() == Fluids.WATER));
                pLevel.setBlockAndUpdate(blockpos, blockstate1);
            }
        }
    }

    public static boolean canClusterGrowAtState(BlockState pState) {
        return pState.isAir() || pState.is(Blocks.WATER) && pState.getFluidState().getAmount() == 8;
    }
}

