/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class MercuryCactusBlock
extends PipeBlock {
    public static final MapCodec<MercuryCactusBlock> CODEC = MercuryCactusBlock.simpleCodec(MercuryCactusBlock::new);

    public MercuryCactusBlock(BlockBehaviour.Properties pProperties) {
        super(0.3125f, pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.FALSE)).setValue((Property)EAST, (Comparable)Boolean.FALSE)).setValue((Property)SOUTH, (Comparable)Boolean.FALSE)).setValue((Property)WEST, (Comparable)Boolean.FALSE)).setValue((Property)UP, (Comparable)Boolean.FALSE)).setValue((Property)DOWN, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends PipeBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.getStateForPlacement((BlockGetter)pContext.getLevel(), pContext.getClickedPos());
    }

    public BlockState getStateForPlacement(BlockGetter pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos.below());
        BlockState blockstate1 = pLevel.getBlockState(pPos.above());
        BlockState blockstate2 = pLevel.getBlockState(pPos.north());
        BlockState blockstate3 = pLevel.getBlockState(pPos.east());
        BlockState blockstate4 = pLevel.getBlockState(pPos.south());
        BlockState blockstate5 = pLevel.getBlockState(pPos.west());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(blockstate.is((Block)this) || blockstate.isSolidRender(pLevel, pPos.below())))).setValue((Property)UP, (Comparable)Boolean.valueOf(blockstate1.is((Block)this) || blockstate1.isSolidRender(pLevel, pPos.above())))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(blockstate2.is((Block)this) || blockstate2.isSolidRender(pLevel, pPos.north())))).setValue((Property)EAST, (Comparable)Boolean.valueOf(blockstate3.is((Block)this) || blockstate3.isSolidRender(pLevel, pPos.east())))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(blockstate4.is((Block)this) || blockstate4.isSolidRender(pLevel, pPos.south())))).setValue((Property)WEST, (Comparable)Boolean.valueOf(blockstate5.is((Block)this) || blockstate5.isSolidRender(pLevel, pPos.west())));
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState newState = this.defaultBlockState();
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pCurrentPos.relative(direction);
            BlockState blockstate1 = pLevel.getBlockState(blockpos);
            if (!blockstate1.is((Block)this) && !blockstate1.isSolidRender((BlockGetter)pLevel, blockpos)) continue;
            newState = (BlockState)newState.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return newState;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockState newState = this.updateShape(pState, Direction.UP, pState, (LevelAccessor)pLevel, pPos, pPos);
        if (!pState.canSurvive((LevelReader)pLevel, pPos)) {
            // empty if block
        }
        pLevel.setBlock(pPos, newState, 3);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.hurt(level.damageSources().cactus(), 1.0f);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos.below());
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pPos.relative(direction);
            BlockState blockstate1 = pLevel.getBlockState(blockpos);
            if (!blockstate1.is((Block)this) && !blockstate1.isSolidRender((BlockGetter)pLevel, blockpos)) continue;
            return true;
        }
        return blockstate.is((Block)this) || blockstate.isSolidRender((BlockGetter)pLevel, pPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

