/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.particle.ColdAirParticleData;
import com.lightning.northstar.world.NorthstarTemperature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MethaneIceBlock
extends HalfTransparentBlock {
    public MethaneIceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void playerDestroy(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        super.playerDestroy(pLevel, pPlayer, pPos, pState, pTe, pStack);
        if (EnchantmentHelper.getItemEnchantmentLevel((Holder)pLevel.holderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)pStack) == 0) {
            if ((float)NorthstarTemperature.getBoilingPoint(NorthstarFluids.METHANE.getSource().defaultFluidState()) < NorthstarTemperature.getTemperatureAt(pLevel, (Vec3i)pPos)) {
                this.evaporate(pState, pLevel, pPos);
            } else if ((float)NorthstarTemperature.getFreezingPoint(NorthstarFluids.METHANE.getSource().defaultFluidState()) < NorthstarTemperature.getTemperatureAt(pLevel, (Vec3i)pPos)) {
                this.melt(pState, pLevel, pPos);
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (random.nextInt(5) != 0 && NorthstarTemperature.getTemperatureAt(level, (Vec3i)pos) < (float)NorthstarTemperature.getFreezingPoint(NorthstarFluids.METHANE.getSource().defaultFluidState())) {
            return;
        }
        for (Direction dir : Direction.values()) {
            if (!level.getBlockState(pos.relative(dir)).is(NorthstarTags.NorthstarBlockTags.AIR_PASSES_THROUGH.tag) || random.nextInt(20) != 0) continue;
            double d0 = (double)x + (double)(dir.getStepX() / 2) + random.nextDouble();
            double d1 = (double)y + 0.7;
            double d2 = (double)z + (double)(dir.getStepZ() / 2) + random.nextDouble();
            level.addParticle((ParticleOptions)new ColdAirParticleData(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((float)NorthstarTemperature.getBoilingPoint(NorthstarFluids.METHANE.getSource().defaultFluidState()) < NorthstarTemperature.getTemperatureAt((Level)pLevel, (Vec3i)pPos)) {
            this.evaporate(pState, (Level)pLevel, pPos);
        } else if ((float)NorthstarTemperature.getFreezingPoint(NorthstarFluids.METHANE.getSource().defaultFluidState()) < NorthstarTemperature.getTemperatureAt((Level)pLevel, (Vec3i)pPos)) {
            this.melt(pState, (Level)pLevel, pPos);
        }
    }

    protected void melt(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.setBlockAndUpdate(pPos, NorthstarFluids.METHANE.getSource().getFluidType().getBlockForFluidState((BlockAndTintGetter)pLevel, pPos, NorthstarFluids.METHANE.getSource().defaultFluidState()));
        pLevel.neighborChanged(pPos, NorthstarFluids.METHANE.getSource().getFluidType().getBlockForFluidState((BlockAndTintGetter)pLevel, pPos, NorthstarFluids.METHANE.getSource().defaultFluidState()).getBlock(), pPos);
    }

    protected void evaporate(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.setBlockAndUpdate(pPos, Blocks.AIR.defaultBlockState());
        pLevel.neighborChanged(pPos, Blocks.AIR, pPos);
        int i = pPos.getX();
        int j = pPos.getY();
        int k = pPos.getZ();
        pLevel.playSound(null, pPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (pLevel.random.nextFloat() - pLevel.random.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

