/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VenusTallMyceliumBlock
extends BushBlock {
    private static final MapCodec<VenusTallMyceliumBlock> CODEC = VenusTallMyceliumBlock.simpleCodec(VenusTallMyceliumBlock::new);
    protected static final BooleanProperty IS_ON_CEILING = BooleanProperty.create((String)"is_on_ceiling");
    protected static final VoxelShape GROUND_SHAPE = VenusTallMyceliumBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    protected static final VoxelShape CEILING_SHAPE = VenusTallMyceliumBlock.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public VenusTallMyceliumBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{IS_ON_CEILING}));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)IS_ON_CEILING) != false ? CEILING_SHAPE : GROUND_SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos otherPos = (Boolean)state.getValue((Property)IS_ON_CEILING) != false ? pos.above() : pos.below();
        Direction direction = (Boolean)state.getValue((Property)IS_ON_CEILING) != false ? Direction.DOWN : Direction.UP;
        BlockState blockstate = level.getBlockState(otherPos);
        return blockstate.is(BlockTags.MUSHROOM_GROW_BLOCK) || blockstate.canSustainPlant((BlockGetter)level, otherPos, direction, state).isTrue();
    }

    protected boolean mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.isSolidRender(pLevel, pPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(pContext.getClickedFace() == Direction.DOWN));
    }
}

