/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.ice_box;

import com.lightning.northstar.block.tech.ice_box.FreezingRecipe;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public abstract class FreezingRecipeGen
extends BaseRecipeProvider {
    public FreezingRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String defaultNamespace) {
        super(output, registries, defaultNamespace);
    }

    protected BaseRecipeProvider.GeneratedRecipe createGas(String name, int temperature, TagKey<Fluid> fluidTag, Supplier<? extends Fluid> fluid, TagKey<Fluid> gasTag, Supplier<? extends Fluid> gas) {
        this.create(name + "_condensation", b -> ((FreezingRecipeBuilder)((FreezingRecipeBuilder)b.colderThan(temperature).duration(20)).require(gasTag, 100)).output((Fluid)fluid.get(), 100));
        return this.create(name + "_evaporation", b -> ((FreezingRecipeBuilder)((FreezingRecipeBuilder)b.hotterThan(temperature).duration(20)).require(fluidTag, 100)).output((Fluid)gas.get(), 100));
    }

    protected BaseRecipeProvider.GeneratedRecipe create(String name, Consumer<FreezingRecipeBuilder> transform) {
        FreezingRecipeBuilder builder = new FreezingRecipeBuilder((ProcessingRecipe.Factory<FreezingRecipe.Params, FreezingRecipe>)((ProcessingRecipe.Factory)FreezingRecipe::new), this.asResource(name));
        transform.accept(builder);
        BaseRecipeProvider.GeneratedRecipe generatedRecipe = arg_0 -> ((FreezingRecipeBuilder)builder).build(arg_0);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    public String getName() {
        return this.modid + "'s freezing recipes";
    }

    public static class FreezingRecipeBuilder
    extends ProcessingRecipeBuilder<FreezingRecipe.Params, FreezingRecipe, FreezingRecipeBuilder> {
        public FreezingRecipeBuilder(ProcessingRecipe.Factory<FreezingRecipe.Params, FreezingRecipe> factory, ResourceLocation recipeId) {
            super(factory, recipeId);
        }

        public FreezingRecipeBuilder colderThan(int temp) {
            return this.withinTemperature(Integer.MIN_VALUE, temp);
        }

        public FreezingRecipeBuilder hotterThan(int temp) {
            return this.withinTemperature(temp, Integer.MAX_VALUE);
        }

        public FreezingRecipeBuilder withTemperature(int temp) {
            return this.withinTemperature(temp, temp);
        }

        public FreezingRecipeBuilder withinTemperature(int min, int max) {
            ((FreezingRecipe.Params)this.params).minTemperature = min;
            ((FreezingRecipe.Params)this.params).maxTemperature = max;
            return this;
        }

        protected FreezingRecipe.Params createParams() {
            return new FreezingRecipe.Params();
        }

        public FreezingRecipeBuilder self() {
            return this;
        }
    }
}

