/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_filler;

import com.lightning.northstar.block.tech.oxygen_filler.OxygenFillerBlock;
import com.lightning.northstar.block.tech.oxygen_filler.OxygenFillerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class OxygenFillerRenderer
extends SmartBlockEntityRenderer<OxygenFillerBlockEntity> {
    public OxygenFillerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(OxygenFillerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        ItemStack item = be.container.getItem(0);
        if (!item.isEmpty()) {
            ms.pushPose();
            Direction direction = (Direction)be.getBlockState().getValue(OxygenFillerBlock.HORIZONTAL_FACING);
            switch (direction) {
                case NORTH: {
                    ms.translate(0.5f, 0.35f, 0.25f);
                    break;
                }
                case SOUTH: {
                    ms.translate(0.5f, 0.35f, 0.75f);
                    break;
                }
                case EAST: {
                    ms.translate(0.75f, 0.35f, 0.5f);
                    break;
                }
                case WEST: {
                    ms.translate(0.25f, 0.35f, 0.5f);
                }
            }
            TransformStack.of((PoseStack)ms).rotateY(AngleHelper.horizontalAngle((Direction)direction) * ((float)Math.PI / 180));
            Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.GROUND, light, overlay, ms, buffer, null, 0);
            ms.popPose();
        }
    }
}

