/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.compat.jei;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.circuit_engraver.EngravingRecipe;
import com.lightning.northstar.block.tech.electrolysis_machine.ElectrolysisRecipe;
import com.lightning.northstar.block.tech.ice_box.FreezingRecipe;
import com.lightning.northstar.compat.jei.category.ElectrolysisCategory;
import com.lightning.northstar.compat.jei.category.EngravingCategory;
import com.lightning.northstar.compat.jei.category.FreezingCategory;
import com.lightning.northstar.compat.jei.category.FuelTypeCategory;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarRegistries;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@JeiPlugin
public class NorthstarJEI
implements IModPlugin {
    private static final ResourceLocation ID = Northstar.asResource("jei_plugin");
    private final List<CreateRecipeCategory<?>> northstarCategories = new ArrayList();

    private void loadCategories() {
        this.northstarCategories.clear();
        Object start = null;
        CreateRecipeCategory engraving = this.builder(EngravingRecipe.class).addTypedRecipes(NorthstarRecipeTypes.ENGRAVING).catalyst(() -> NorthstarBlocks.CIRCUIT_ENGRAVER.get()).itemIcon((ItemLike)NorthstarBlocks.CIRCUIT_ENGRAVER.get()).emptyBackground(177, 70).build("engraving", EngravingCategory::new);
        CreateRecipeCategory freezing = this.builder(FreezingRecipe.class).addTypedRecipes(NorthstarRecipeTypes.FREEZING).catalyst(() -> NorthstarBlocks.ICE_BOX.get()).itemIcon((ItemLike)NorthstarBlocks.ICE_BOX.get()).emptyBackground(177, 70).build("freezing", FreezingCategory::new);
        CreateRecipeCategory electrolysis = this.builder(ElectrolysisRecipe.class).addTypedRecipes(NorthstarRecipeTypes.ELECTROLYSIS).catalyst(() -> NorthstarBlocks.ELECTROLYSIS_MACHINE.get()).itemIcon((ItemLike)NorthstarBlocks.ELECTROLYSIS_MACHINE.get()).emptyBackground(177, 70).build("electrolysis", ElectrolysisCategory::new);
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.northstarCategories.toArray(IRecipeCategory[]::new));
        registration.addRecipeCategories(new IRecipeCategory[]{new FuelTypeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.northstarCategories.forEach(c -> c.registerRecipes(registration));
        RegistryAccess registryAccess = RegistryUtil.getRegistryAccess();
        Registry fluids = registryAccess.registryOrThrow(Registries.FLUID);
        registration.addRecipes(FuelTypeCategory.RECIPE_TYPE, registryAccess.registryOrThrow(NorthstarRegistries.FUEL).stream().filter(fuel -> fluids.stream().anyMatch(fuel::supports)).toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.northstarCategories.forEach(c -> c.registerCatalysts(registration));
        registration.addRecipeCatalysts(FuelTypeCategory.RECIPE_TYPE, new ItemLike[]{NorthstarBlocks.JET_ENGINE, NorthstarBlocks.COMBUSTION_ENGINE});
    }

    public static void consumeAllRecipes(Consumer<RecipeHolder<?>> consumer) {
        Minecraft.getInstance().getConnection().getRecipeManager().getRecipes().forEach(consumer);
    }

    public static boolean doInputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
        if (recipe1.getIngredients().isEmpty() || recipe2.getIngredients().isEmpty()) {
            return false;
        }
        ItemStack[] matchingStacks = ((Ingredient)recipe1.getIngredients().get(0)).getItems();
        if (matchingStacks.length == 0) {
            return false;
        }
        return ((Ingredient)recipe2.getIngredients().get(0)).test(matchingStacks[0]);
    }

    public static boolean doOutputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
        RegistryAccess registry = Minecraft.getInstance().level.registryAccess();
        return ItemStack.isSameItem((ItemStack)recipe1.getResultItem((HolderLookup.Provider)registry), (ItemStack)recipe2.getResultItem((HolderLookup.Provider)registry));
    }

    private class CategoryBuilder<T extends Recipe<?>>
    extends CreateRecipeCategory.Builder<T> {
        public CategoryBuilder(Class<? extends T> recipeClass) {
            super(recipeClass);
        }

        public CreateRecipeCategory<T> build(ResourceLocation id, CreateRecipeCategory.Factory<T> factory) {
            CreateRecipeCategory category = super.build(id, factory);
            NorthstarJEI.this.northstarCategories.add(category);
            return category;
        }
    }
}

