/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.entity.MarsWormEntity;
import com.lightning.northstar.entity.goals.EatRootsGoal;
import com.lightning.northstar.entity.goals.RunToGroupGoal;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MarsToadEntity
extends Monster
implements GeoAnimatable,
RangedAttackMob {
    private static final ResourceLocation SPEED_MODIFIER_ATTACKING_ID = Northstar.asResource("attacking");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_ID, 0.2, AttributeModifier.Operation.ADD_VALUE);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int eating = 0;

    public MarsToadEntity(EntityType<? extends MarsToadEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private PlayState predicate(AnimationState<MarsToadEntity> event) {
        if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else if (this.eating > 0) {
            --this.eating;
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().then("eat", Animation.LoopType.PLAY_ONCE));
        } else {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 10) {
            this.eating = 40;
        }
        super.handleEntityEvent(pId);
    }

    public static boolean toadSpawnRules(EntityType<MarsToadEntity> toad, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
        BlockState state = level.getBlockState(pos.below());
        if (pos.getY() >= surfaceY) {
            return false;
        }
        if (pos.getY() > surfaceY / 2) {
            int light = level.getMaxLocalRawBrightness(pos);
            return light > 7 ? false : MarsToadEntity.checkMobSpawnRules(toad, (LevelAccessor)level, (MobSpawnType)spawntype, (BlockPos)pos, (RandomSource)rando) && (state.is(NorthstarTags.NorthstarBlockTags.NATURAL_MARS_BLOCKS.tag) || state.isAir());
        }
        return false;
    }

    public void tick() {
        super.tick();
    }

    protected void customServerAiStep() {
        AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (this.getTarget() != null) {
            if (!attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
                attributeinstance.addTransientModifier(SPEED_MODIFIER_ATTACKING);
            }
        } else if (attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
            attributeinstance.removeModifier(SPEED_MODIFIER_ATTACKING);
        }
        super.customServerAiStep();
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return (SoundEvent)NorthstarSounds.MARS_TOAD_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.MARS_TOAD_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)NorthstarSounds.MARS_TOAD_DEATH.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new EatRootsGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new AvoidEntityGoal((PathfinderMob)this, MarsWormEntity.class, 6.0f, 1.0, 1.35));
        this.goalSelector.addGoal(9, new RunToGroupGoal<Player>((PathfinderMob)this, Player.class, 7.0f, 1.0, 1.2));
        super.registerGoals();
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.RAVAGER_ATTACK, 1.0f, 1.0f);
        return super.doHurtTarget(pEntity);
    }

    public void performRangedAttack(LivingEntity pTarget, float pVelocity) {
    }

    static class ShootAcidGoal
    extends Goal {
        private final MarsToadEntity shooter;
        public int chargeTime;

        public ShootAcidGoal(MarsToadEntity shooter) {
            this.shooter = shooter;
        }

        public boolean canUse() {
            return this.shooter.getTarget() != null;
        }

        public void start() {
            this.chargeTime = 0;
        }

        public void stop() {
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.shooter.getTarget();
            if (livingentity != null) {
                if (livingentity.distanceToSqr((Entity)this.shooter) < 4096.0 && this.shooter.hasLineOfSight((Entity)livingentity)) {
                    Level level = this.shooter.level();
                    ++this.chargeTime;
                    if (this.chargeTime == 20) {
                        Vec3 vec3 = this.shooter.getViewVector(1.0f);
                        double d2 = livingentity.getX() - (this.shooter.getX() + vec3.x * 4.0);
                        double d3 = livingentity.getY(0.5) - (0.5 + this.shooter.getY(0.5));
                        double d4 = livingentity.getZ() - (this.shooter.getZ() + vec3.z * 4.0);
                        LargeFireball largefireball = new LargeFireball(level, (LivingEntity)this.shooter, new Vec3(d2, d3, d4), 2);
                        largefireball.setPos(this.shooter.getX() + vec3.x, this.shooter.getY(0.5), largefireball.getZ() + vec3.z);
                        level.addFreshEntity((Entity)largefireball);
                        this.chargeTime = -40;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
            }
        }
    }

    static class StareAtTargetGoal
    extends Goal {
        private final MarsToadEntity shooter;

        public StareAtTargetGoal(MarsToadEntity pShooter) {
            this.shooter = pShooter;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return true;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            if (this.shooter.getTarget() == null) {
                Vec3 vec3 = this.shooter.getDeltaMovement();
                this.shooter.setYRot(-((float)Mth.atan2((double)vec3.x, (double)vec3.z)) * 57.295776f);
                this.shooter.yBodyRot = this.shooter.getYRot();
            } else {
                LivingEntity livingentity = this.shooter.getTarget();
                if (livingentity.distanceToSqr((Entity)this.shooter) < 4096.0) {
                    double d1 = livingentity.getX() - this.shooter.getX();
                    double d2 = livingentity.getZ() - this.shooter.getZ();
                    this.shooter.setYRot(-((float)Mth.atan2((double)d1, (double)d2)) * 57.295776f);
                    this.shooter.yBodyRot = this.shooter.getYRot();
                }
            }
        }
    }
}

