/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.gravitystuff;

import com.lightning.northstar.world.dimension.NorthstarDimensions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public class ItemEntityGravityMixin {
    @Unique
    private static final double CONSTANT = 0.03;
    private static final double EARTH_GRAV = 1.0;
    private static final double MARS_GRAV = 0.37;
    private static final double MOON_GRAV = 0.16;
    private static final double VENUS_GRAV = 0.88;
    private static final double MERCURY_GRAV = 0.38;
    private static final double ORBIT_GRAV = 0.06;
    double PLANET_GRAV = 1.0;

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void northstar$tick(CallbackInfo ci) {
        Entity entity = (Entity)this;
        Vec3 velocity = entity.getDeltaMovement();
        this.PLANET_GRAV = entity.level().dimension() == NorthstarDimensions.MARS_DIM_KEY ? 0.37 : (entity.level().dimension() == NorthstarDimensions.MOON_DIM_KEY ? 0.16 : (entity.level().dimension() == NorthstarDimensions.VENUS_DIM_KEY ? 0.88 : (entity.level().dimension() == NorthstarDimensions.MERCURY_DIM_KEY ? 0.38 : (entity.level().dimension() == NorthstarDimensions.EARTH_ORBIT_DIM_KEY ? 0.06 : 1.0))));
        if (!entity.isNoGravity()) {
            double newGrav = 0.03 * this.PLANET_GRAV;
            entity.setDeltaMovement(velocity.x(), velocity.y() + 0.03 - newGrav, velocity.z());
        }
        if (this.PLANET_GRAV == 0.37 && entity.level().getRainLevel(0.0f) > 0.0f && entity.level().getRawBrightness(entity.blockPosition(), 0) == 15 && !entity.isSpectator()) {
            entity.setDeltaMovement(velocity.x() + 0.01, velocity.y(), velocity.z() - 0.01);
        }
    }
}

