/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world;

import com.lightning.northstar.block.tech.oxygen_sealer.OxygenSealerBlockEntity;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.world.SealingProvider;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.ApiStatus;

@EventBusSubscriber(modid="northstar", value={Dist.CLIENT})
public class NorthstarOxygen {
    public static final int MAXIMUM_OXYGEN = 1800;
    private final Level level;
    private final Set<SealingProvider> providers;

    public NorthstarOxygen(Level level) {
        this.level = level;
        this.providers = new HashSet<SealingProvider>();
    }

    public boolean hasOxygen(Vec3 pos) {
        if (NorthstarPlanets.getPlanetOxy((ResourceKey<Level>)this.level.dimension())) {
            return true;
        }
        for (SealingProvider sealer : this.providers) {
            if (!sealer.isSealed(pos)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOxygen(Vec3i pos) {
        if (NorthstarPlanets.getPlanetOxy((ResourceKey<Level>)this.level.dimension())) {
            return true;
        }
        for (SealingProvider sealer : this.providers) {
            if (!sealer.isSealed(pos)) continue;
            return true;
        }
        return false;
    }

    public void registerSealer(SealingProvider provider) {
        this.providers.add(provider);
    }

    public void unregisterSealer(SealingProvider provider) {
        this.providers.remove(provider);
    }

    public static boolean isOxygen(Fluid fluid) {
        return NorthstarTags.NorthstarFluidTags.C_OXYGEN.matches(fluid) || NorthstarTags.NorthstarFluidTags.IS_OXY.matches(fluid);
    }

    public static boolean hasOxygen(Level level, Vec3 pos) {
        return level.northstar$oxygen().hasOxygen(pos);
    }

    public static boolean hasOxygen(Level level, Vec3i pos) {
        return level.northstar$oxygen().hasOxygen(pos);
    }

    public static NorthstarOxygen getDimension(Level level) {
        return level.northstar$oxygen();
    }

    public static ItemStack getOxy(LivingEntity entity) {
        for (ItemStack items : entity.getArmorSlots()) {
            if (!items.is(NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.tag)) continue;
            return items;
        }
        return ItemStack.EMPTY;
    }

    @ApiStatus.Internal
    public static void tickEntity(LivingEntity entity) {
        Player player;
        Level world = entity.level();
        if (world.getGameTime() % 20L != (long)(entity.getId() % 20)) {
            return;
        }
        if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator())) {
            return;
        }
        if (NorthstarTags.NorthstarEntityTags.DOESNT_REQUIRE_OXYGEN.matches((Entity)entity)) {
            return;
        }
        if (NorthstarOxygen.hasOxygen(entity.level(), entity.getEyePosition())) {
            return;
        }
        boolean isFullyCovered = true;
        ItemStack oxygenSource = ItemStack.EMPTY;
        for (ItemStack armor : entity.getArmorSlots()) {
            if (armor.isEmpty()) {
                isFullyCovered = false;
                break;
            }
            if (!NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.matches(armor)) continue;
            oxygenSource = armor;
        }
        if (!isFullyCovered || oxygenSource.isEmpty() || !NorthstarOxygen.depleteOxygen(oxygenSource)) {
            entity.hurt(world.damageSources().northstar$suffocation(), 1.0f);
        }
    }

    public static boolean depleteOxygen(ItemStack stack) {
        if (!stack.has(NorthstarDataComponents.OXYGEN)) {
            return false;
        }
        int oxygen = (Integer)stack.get(NorthstarDataComponents.OXYGEN);
        if (oxygen <= 0) {
            return false;
        }
        stack.set(NorthstarDataComponents.OXYGEN, (Object)Math.min(oxygen - 1, 1800));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPostRender(RenderLevelStageEvent event) {
        if (!((Boolean)NorthstarConfigs.client().debugSealerBounds.get()).booleanValue()) {
            return;
        }
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            PoseStack pose = event.getPoseStack();
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            pose.pushPose();
            pose.translate(-pos.x, -pos.y, -pos.z);
            for (SealingProvider provider : NorthstarOxygen.getDimension((Level)Minecraft.getInstance().level).providers) {
                if (!(provider instanceof OxygenSealerBlockEntity)) continue;
                OxygenSealerBlockEntity sealer = (OxygenSealerBlockEntity)provider;
                sealer.getSealer().getVisualizer().render(pose, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource());
            }
            pose.popPose();
        }
    }
}

