/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features;

import com.lightning.northstar.content.NorthstarBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MercuryShelvesFeature
extends Feature<NoneFeatureConfiguration> {
    public MercuryShelvesFeature(Codec<NoneFeatureConfiguration> p_65360_) {
        super(p_65360_);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        BlockPos blockpos = pContext.origin();
        RandomSource rando = pContext.random();
        WorldGenLevel level = pContext.level();
        if (level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).getY() <= blockpos.getY()) {
            return false;
        }
        boolean flag = false;
        for (int i = 0; i < 10; ++i) {
            BlockPos newpos;
            if (!rando.nextBoolean() || level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, newpos = blockpos.offset(rando.nextInt(-7, 7), rando.nextInt(-7, 7), rando.nextInt(-7, 7))).getY() - 5 <= newpos.getY() || !this.placeShelf(level, rando, newpos.mutable())) continue;
            flag = true;
        }
        return flag;
    }

    protected boolean placeShelf(WorldGenLevel level, RandomSource pRandom, BlockPos.MutableBlockPos pPos) {
        int z;
        int x;
        boolean flag = false;
        for (x = -2; x < 3; ++x) {
            for (z = -2; z < 3; ++z) {
                if (!level.getBlockState(pPos.offset(x, 0, z)).isSolidRender((BlockGetter)level, pPos.offset(x, 0, z))) continue;
                flag = true;
            }
        }
        if (flag) {
            for (x = -2; x < 3; ++x) {
                for (z = -2; z < 3; ++z) {
                    if (Mth.abs((int)x) + Mth.abs((int)z) == 4 || level.getBlockState(pPos.offset(x, 0, z)).isSolidRender((BlockGetter)level, pPos.offset(x, 0, z))) continue;
                    level.setBlock(pPos.offset(x, 0, z), ((HugeMushroomBlock)NorthstarBlocks.MERCURY_SHELF_FUNGUS_BLOCK.get()).defaultBlockState(), 3);
                }
            }
        }
        return flag;
    }
}

