/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features;

import com.lightning.northstar.world.features.configuration.StoneColumnConfiguration;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StoneColumnFeature
extends Feature<StoneColumnConfiguration> {
    public StoneColumnFeature(Codec<StoneColumnConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<StoneColumnConfiguration> pContext) {
        Object t;
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        StoneColumnConfiguration largedripstoneconfiguration = (StoneColumnConfiguration)pContext.config();
        RandomSource randomsource = pContext.random();
        if (!StoneColumnFeature.isEmptyOrWater((LevelAccessor)worldgenlevel, blockpos)) {
            return false;
        }
        Optional optional = Column.scan((LevelSimulatedReader)worldgenlevel, (BlockPos)blockpos, (int)largedripstoneconfiguration.floorToCeilingSearchRange(), DripstoneUtils::isEmptyOrWater, DripstoneUtils::isDripstoneBaseOrLava);
        if (optional.isPresent() && (t = optional.get()) instanceof Column.Range) {
            Column.Range column$range = (Column.Range)t;
            if (column$range.height() < 4) {
                return false;
            }
            int i = (int)((float)column$range.height() * largedripstoneconfiguration.maxColumnRadiusToCaveHeightRatio());
            int j = Mth.clamp((int)i, (int)largedripstoneconfiguration.columnRadius().getMinValue(), (int)largedripstoneconfiguration.columnRadius().getMaxValue());
            int k = Mth.randomBetweenInclusive((RandomSource)randomsource, (int)largedripstoneconfiguration.columnRadius().getMinValue(), (int)j);
            LargeDripstone largedripstonefeature$largedripstone = StoneColumnFeature.makeDripstone(blockpos.atY(column$range.ceiling() - 1), false, randomsource, k, largedripstoneconfiguration.stalactiteBluntness(), largedripstoneconfiguration.heightScale());
            LargeDripstone largedripstonefeature$largedripstone1 = StoneColumnFeature.makeDripstone(blockpos.atY(column$range.floor() + 1), true, randomsource, k, largedripstoneconfiguration.stalagmiteBluntness(), largedripstoneconfiguration.heightScale());
            WindOffsetter largedripstonefeature$windoffsetter = largedripstonefeature$largedripstone.isSuitableForWind(largedripstoneconfiguration) && largedripstonefeature$largedripstone1.isSuitableForWind(largedripstoneconfiguration) ? new WindOffsetter(blockpos.getY(), randomsource, largedripstoneconfiguration.windSpeed()) : WindOffsetter.noWind();
            boolean flag = largedripstonefeature$largedripstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            boolean flag1 = largedripstonefeature$largedripstone1.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            if (flag) {
                largedripstonefeature$largedripstone.placeBlocks(worldgenlevel, randomsource, largedripstonefeature$windoffsetter, (StoneColumnConfiguration)pContext.config());
            }
            if (flag1) {
                largedripstonefeature$largedripstone1.placeBlocks(worldgenlevel, randomsource, largedripstonefeature$windoffsetter, (StoneColumnConfiguration)pContext.config());
            }
            return true;
        }
        return false;
    }

    private static LargeDripstone makeDripstone(BlockPos pRoot, boolean pPointingUp, RandomSource pRandom, int pRadius, FloatProvider pBluntnessBase, FloatProvider pScaleBase) {
        return new LargeDripstone(pRoot, pPointingUp, pRadius, pBluntnessBase.sample(pRandom), pScaleBase.sample(pRandom));
    }

    private void placeDebugMarkers(WorldGenLevel pLevel, BlockPos pPos, Column.Range pRange, WindOffsetter pWindOffsetter) {
        pLevel.setBlock(pWindOffsetter.offset(pPos.atY(pRange.ceiling() - 1)), Blocks.DIAMOND_BLOCK.defaultBlockState(), 2);
        pLevel.setBlock(pWindOffsetter.offset(pPos.atY(pRange.floor() + 1)), Blocks.GOLD_BLOCK.defaultBlockState(), 2);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.atY(pRange.floor() + 2).mutable();
        while (blockpos$mutableblockpos.getY() < pRange.ceiling() - 1) {
            BlockPos blockpos = pWindOffsetter.offset((BlockPos)blockpos$mutableblockpos);
            if (StoneColumnFeature.isEmptyOrWater((LevelAccessor)pLevel, blockpos) || pLevel.getBlockState(blockpos).is(Blocks.DRIPSTONE_BLOCK)) {
                pLevel.setBlock(blockpos, Blocks.CREEPER_HEAD.defaultBlockState(), 2);
            }
            blockpos$mutableblockpos.move(Direction.UP);
        }
    }

    protected static boolean isEmptyOrWater(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, StoneColumnFeature::isEmptyOrWater);
    }

    public static boolean isEmptyOrWater(BlockState p_159665_) {
        return p_159665_.isAir() || p_159665_.is(Blocks.WATER);
    }

    protected static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel pLevel, BlockPos pPos, int pRadius) {
        if (StoneColumnFeature.isEmptyOrWaterOrLava((LevelAccessor)pLevel, pPos)) {
            return false;
        }
        float f = 6.0f;
        float f1 = 6.0f / (float)pRadius;
        for (float f2 = 0.0f; f2 < (float)Math.PI * 2; f2 += f1) {
            int j;
            int i = (int)(Mth.cos((float)f2) * (float)pRadius);
            if (!StoneColumnFeature.isEmptyOrWaterOrLava((LevelAccessor)pLevel, pPos.offset(i, 0, j = (int)(Mth.sin((float)f2) * (float)pRadius)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEmptyOrWaterOrLava(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, StoneColumnFeature::isEmptyOrWaterOrLava);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState p_159667_) {
        return p_159667_.isAir() || p_159667_.is(Blocks.WATER) || p_159667_.is(Blocks.LAVA);
    }

    protected static double getDripstoneHeight(double pRadius, double pMaxRadius, double pScale, double pMinRadius) {
        if (pRadius < pMinRadius) {
            pRadius = pMinRadius;
        }
        double d0 = 0.384;
        double d1 = pRadius / pMaxRadius * 0.384;
        double d2 = 0.75 * Math.pow(d1, 1.3333333333333333);
        double d3 = Math.pow(d1, 0.6666666666666666);
        double d4 = 0.3333333333333333 * Math.log(d1);
        double d5 = pScale * (d2 - d3 - d4);
        d5 = Math.max(d5, 0.0);
        return d5 / 0.384 * pMaxRadius;
    }

    static final class LargeDripstone {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeDripstone(BlockPos pRoot, boolean pPointingUp, int pRadius, double pBluntness, double pScale) {
            this.root = pRoot;
            this.pointingUp = pPointingUp;
            this.radius = pRadius;
            this.bluntness = pBluntness;
            this.scale = pScale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.getY() : this.root.getY() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.getY() : this.root.getY() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel pLevel, WindOffsetter pWindOffsetter) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.mutable();
                int i = Math.min(10, this.getHeight());
                for (int j = 0; j < i; ++j) {
                    if (pLevel.getBlockState((BlockPos)blockpos$mutableblockpos).is(Blocks.LAVA)) {
                        return false;
                    }
                    if (StoneColumnFeature.isCircleMostlyEmbeddedInStone(pLevel, pWindOffsetter.offset((BlockPos)blockpos$mutableblockpos), this.radius)) {
                        this.root = blockpos$mutableblockpos;
                        return true;
                    }
                    blockpos$mutableblockpos.move(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float pRadius) {
            return (int)StoneColumnFeature.getDripstoneHeight(pRadius, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(WorldGenLevel pLevel, RandomSource pRandom, WindOffsetter pWindOffsetter, StoneColumnConfiguration config) {
            for (int i = -this.radius; i <= this.radius; ++i) {
                block1: for (int j = -this.radius; j <= this.radius; ++j) {
                    int k;
                    float f = Mth.sqrt((float)(i * i + j * j));
                    if (f > (float)this.radius || (k = this.getHeightAtRadius(f)) <= 0) continue;
                    if ((double)pRandom.nextFloat() < 0.2) {
                        k = (int)((float)k * Mth.randomBetween((RandomSource)pRandom, (float)0.8f, (float)1.0f));
                    }
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.offset(i, 0, j).mutable();
                    boolean flag = false;
                    int l = this.pointingUp ? pLevel.getHeight(Heightmap.Types.WORLD_SURFACE_WG, blockpos$mutableblockpos.getX(), blockpos$mutableblockpos.getZ()) : Integer.MAX_VALUE;
                    for (int i1 = 0; i1 < k && blockpos$mutableblockpos.getY() < l; ++i1) {
                        BlockPos blockpos = pWindOffsetter.offset((BlockPos)blockpos$mutableblockpos);
                        if (StoneColumnFeature.isEmptyOrWaterOrLava((LevelAccessor)pLevel, blockpos)) {
                            flag = true;
                            pLevel.setBlock(blockpos, config.stoneProvider().getState(pRandom, (BlockPos)blockpos$mutableblockpos), 2);
                        } else if (flag) continue block1;
                        blockpos$mutableblockpos.move(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        boolean isSuitableForWind(StoneColumnConfiguration pConfig) {
            return this.radius >= pConfig.minRadiusForWind() && this.bluntness >= (double)pConfig.minBluntnessForWind();
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3 windSpeed;

        WindOffsetter(int pOriginY, RandomSource pRandom, FloatProvider pMagnitude) {
            this.originY = pOriginY;
            float f = pMagnitude.sample(pRandom);
            float f1 = Mth.randomBetween((RandomSource)pRandom, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new Vec3((double)(Mth.cos((float)f1) * f), 0.0, (double)(Mth.sin((float)f1) * f));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        BlockPos offset(BlockPos pPos) {
            if (this.windSpeed == null) {
                return pPos;
            }
            int i = this.originY - pPos.getY();
            Vec3 vec3 = this.windSpeed.scale((double)i);
            return pPos.offset((int)vec3.x, 0, (int)vec3.z);
        }
    }
}

