/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.content.NorthstarBlocks;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class PointedCrimsiteBlock
extends PointedDripstoneBlock
implements Fallable,
SimpleWaterloggedBlock {
    public PointedCrimsiteBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_154009_, (Comparable)Direction.UP)).m_61124_((Property)f_154010_, (Comparable)DripstoneThickness.TIP)).m_61124_((Property)f_154011_, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = pContext.m_43725_();
        Direction direction1 = PointedCrimsiteBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = pContext.m_8083_(), direction = pContext.m_151260_().m_122424_());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !pContext.m_7078_();
        DripstoneThickness dripstonethickness = PointedCrimsiteBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_154009_, (Comparable)direction1)).m_61124_((Property)f_154010_, (Comparable)dripstonethickness)).m_61124_((Property)f_154011_, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader pLevel, BlockPos pPos, Direction pDir, boolean pIsTipMerge) {
        Direction direction = pDir.m_122424_();
        BlockState blockstate = pLevel.m_8055_(pPos.m_121945_(pDir));
        if (PointedCrimsiteBlock.isPointedDripstoneWithDirection(blockstate, direction)) {
            return !pIsTipMerge && blockstate.m_61143_((Property)f_154010_) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedCrimsiteBlock.isPointedDripstoneWithDirection(blockstate, pDir)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.m_61143_((Property)f_154010_);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = pLevel.m_8055_(pPos.m_121945_(direction));
            return !PointedCrimsiteBlock.isPointedDripstoneWithDirection(blockstate1, pDir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (PointedCrimsiteBlock.isStalagmite(pState) && !this.m_7898_(pState, (LevelReader)pLevel, pPos)) {
            pLevel.m_46961_(pPos, true);
        } else {
            PointedCrimsiteBlock.spawnFallingStalactite(pState, pLevel, pPos);
        }
    }

    private static void spawnFallingStalactite(BlockState pState, ServerLevel pLevel, BlockPos pPos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        BlockState blockstate = pState;
        while (PointedCrimsiteBlock.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)pLevel, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (PointedCrimsiteBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pPos.m_123342_() - blockpos$mutableblockpos.m_123342_(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.m_149656_(f, 40);
                break;
            }
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
        }
    }

    private static boolean isTip(BlockState pState, boolean pIsTipMerge) {
        if (!pState.m_60713_((Block)NorthstarBlocks.POINTED_CRIMSITE.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)pState.m_61143_((Property)f_154010_);
        return dripstonethickness == DripstoneThickness.TIP || pIsTipMerge && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isStalactite(BlockState pState) {
        return PointedCrimsiteBlock.isPointedDripstoneWithDirection(pState, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState pState) {
        return PointedCrimsiteBlock.isPointedDripstoneWithDirection(pState, Direction.UP);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader pLevel, BlockPos pPos, Direction pDir) {
        Direction direction;
        if (PointedCrimsiteBlock.isValidPointedDripstonePlacement(pLevel, pPos, pDir)) {
            direction = pDir;
        } else {
            if (!PointedCrimsiteBlock.isValidPointedDripstonePlacement(pLevel, pPos, pDir.m_122424_())) {
                return null;
            }
            direction = pDir.m_122424_();
        }
        return direction;
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader pLevel, BlockPos pPos, Direction pDir) {
        BlockPos blockpos = pPos.m_121945_(pDir.m_122424_());
        BlockState blockstate = pLevel.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)pLevel, blockpos, pDir) || PointedCrimsiteBlock.isPointedDripstoneWithDirection(blockstate, pDir);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return PointedCrimsiteBlock.isValidPointedDripstonePlacement(pLevel, pPos, (Direction)pState.m_61143_((Property)f_154009_));
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
    }

    private static boolean isPointedDripstoneWithDirection(BlockState pState, Direction pDir) {
        return pState.m_60713_((Block)NorthstarBlocks.POINTED_CRIMSITE.get()) && pState.m_61143_((Property)f_154009_) == pDir;
    }

    public static void growPointedDripstone(LevelAccessor pLevel, BlockPos pPos, Direction pDirection, int pHeight, boolean pMergeTip, Block block) {
        if (pLevel.m_8055_(pPos.m_121945_(pDirection.m_122424_())).m_60804_((BlockGetter)pLevel, pPos.m_121945_(pDirection.m_122424_()))) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
            PointedCrimsiteBlock.buildBaseToTipColumn(pDirection, pHeight, pMergeTip, p_190846_ -> {
                if (p_190846_.m_60713_(block)) {
                    p_190846_ = (BlockState)p_190846_.m_61124_((Property)f_154011_, (Comparable)Boolean.valueOf(pLevel.m_46801_((BlockPos)blockpos$mutableblockpos)));
                }
                if (!pLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60804_((BlockGetter)pLevel, (BlockPos)blockpos$mutableblockpos)) {
                    pLevel.m_7731_((BlockPos)blockpos$mutableblockpos, p_190846_, 2);
                }
                blockpos$mutableblockpos.m_122173_(pDirection);
                if (!pLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60795_()) {
                    return;
                }
            }, block);
        }
    }

    protected static void buildBaseToTipColumn(Direction pDirection, int pHeight, boolean pMergeTip, Consumer<BlockState> pBlockSetter, Block block) {
        if (pHeight >= 3) {
            pBlockSetter.accept(PointedCrimsiteBlock.createPointedDripstone(pDirection, DripstoneThickness.BASE, block));
            for (int i = 0; i < pHeight - 3; ++i) {
                pBlockSetter.accept(PointedCrimsiteBlock.createPointedDripstone(pDirection, DripstoneThickness.MIDDLE, block));
            }
        }
        if (pHeight >= 2) {
            pBlockSetter.accept(PointedCrimsiteBlock.createPointedDripstone(pDirection, DripstoneThickness.FRUSTUM, block));
        }
        if (pHeight >= 1) {
            pBlockSetter.accept(PointedCrimsiteBlock.createPointedDripstone(pDirection, pMergeTip ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP, block));
        }
    }

    private static BlockState createPointedDripstone(Direction pDirection, DripstoneThickness pDripstoneThickness, Block block) {
        return (BlockState)((BlockState)block.m_49966_().m_61124_((Property)f_154009_, (Comparable)pDirection)).m_61124_((Property)f_154010_, (Comparable)pDripstoneThickness);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)f_154011_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (pDirection != Direction.UP && pDirection != Direction.DOWN) {
            return pState;
        }
        Direction direction = (Direction)pState.m_61143_((Property)f_154009_);
        if (direction == Direction.DOWN && pLevel.m_183326_().m_183582_(pCurrentPos, (Object)this)) {
            return pState;
        }
        if (pDirection == direction.m_122424_() && !this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos)) {
            if (direction == Direction.DOWN) {
                pLevel.m_186460_(pCurrentPos, (Block)this, 2);
            } else {
                pLevel.m_186460_(pCurrentPos, (Block)this, 1);
            }
            return pState;
        }
        boolean flag = pState.m_61143_((Property)f_154010_) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = PointedCrimsiteBlock.calculateDripstoneThickness((LevelReader)pLevel, pCurrentPos, direction, flag);
        return (BlockState)pState.m_61124_((Property)f_154010_, (Comparable)dripstonethickness);
    }
}

