/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.circuit_engraver;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.lightning.northstar.block.tech.circuit_engraver.CircuitEngraverBlockEntity;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import net.minecraft.core.Direction;

public class CircuitEngraverVisual
extends ShaftInstance<CircuitEngraverBlockEntity>
implements DynamicInstance {
    private final RotatingData head;
    private final RotatingData laser;

    public CircuitEngraverVisual(MaterialManager materialManager, CircuitEngraverBlockEntity entity) {
        super(materialManager, (KineticBlockEntity)entity);
        this.head = ((RotatingData)materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(NorthstarPartialModels.CIRCUIT_ENGRAVER_HEAD, this.getRenderedBlockState()).createInstance()).setRotationAxis(Direction.Axis.Y);
        this.laser = ((RotatingData)materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(NorthstarPartialModels.CIRCUIT_ENGRAVER_LASER).createInstance()).setRotationAxis(Direction.Axis.Y);
    }

    public void beginFrame() {
        boolean running = ((CircuitEngraverBlockEntity)this.blockEntity).isRunning();
        float speed = running ? ((CircuitEngraverBlockEntity)this.blockEntity).getSpeed() : 0.0f;
        this.head.setPosition(this.getInstancePosition()).setRotationalSpeed(speed);
        this.laser.setPosition(this.getInstancePosition()).nudge(0.0f, running ? -0.16f : 1.0E8f, 0.0f).setRotationalSpeed(speed * 2.0f);
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.head, this.laser});
    }

    public void remove() {
        super.remove();
        this.head.delete();
        this.laser.delete();
    }
}

