/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.combustion_engine;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.lightning.northstar.block.tech.combustion_engine.CombustionEngineBlock;
import com.lightning.northstar.block.tech.combustion_engine.CombustionEngineBlockEntity;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import org.joml.Quaternionf;

public class CombustionEngineVisual
extends ShaftInstance<CombustionEngineBlockEntity>
implements DynamicInstance {
    private final OrientedData piston1;
    private final OrientedData piston2;
    private final OrientedData piston3;
    private final OrientedData piston4;
    private final OrientedData piston5;
    private final OrientedData piston6;

    public CombustionEngineVisual(MaterialManager materialManager, CombustionEngineBlockEntity entity) {
        super(materialManager, (KineticBlockEntity)entity);
        Quaternionf rotation = Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.m_61143_(CombustionEngineBlock.HORIZONTAL_FACING))));
        this.piston1 = ((OrientedData)materialManager.defaultSolid().material(Materials.ORIENTED).getModel(NorthstarPartialModels.PISTON1).createInstance()).setRotation(rotation);
        this.piston2 = ((OrientedData)materialManager.defaultSolid().material(Materials.ORIENTED).getModel(NorthstarPartialModels.PISTON2).createInstance()).setRotation(rotation);
        this.piston3 = ((OrientedData)materialManager.defaultSolid().material(Materials.ORIENTED).getModel(NorthstarPartialModels.PISTON3).createInstance()).setRotation(rotation);
        this.piston4 = ((OrientedData)materialManager.defaultSolid().material(Materials.ORIENTED).getModel(NorthstarPartialModels.PISTON4).createInstance()).setRotation(rotation);
        this.piston5 = ((OrientedData)materialManager.defaultSolid().material(Materials.ORIENTED).getModel(NorthstarPartialModels.PISTON5).createInstance()).setRotation(rotation);
        this.piston6 = ((OrientedData)materialManager.defaultSolid().material(Materials.ORIENTED).getModel(NorthstarPartialModels.PISTON6).createInstance()).setRotation(rotation);
        this.beginFrame();
    }

    public void beginFrame() {
        float time = AnimationTickHolder.getRenderTime() * Math.signum(((CombustionEngineBlockEntity)this.blockEntity).getSpeed()) * 2.0f;
        this.piston1.setPosition(this.getInstancePosition()).nudge(0.0f, CombustionEngineVisual.getPistonOffset(time), 0.0f);
        this.piston2.setPosition(this.getInstancePosition()).nudge(0.0f, CombustionEngineVisual.getPistonOffset(time + 2.0f), 0.0f);
        this.piston3.setPosition(this.getInstancePosition()).nudge(0.0f, CombustionEngineVisual.getPistonOffset(time + 4.0f), 0.0f);
        this.piston4.setPosition(this.getInstancePosition()).nudge(0.0f, CombustionEngineVisual.getPistonOffset(time + 8.0f), 0.0f);
        this.piston5.setPosition(this.getInstancePosition()).nudge(0.0f, CombustionEngineVisual.getPistonOffset(time + 10.0f), 0.0f);
        this.piston6.setPosition(this.getInstancePosition()).nudge(0.0f, CombustionEngineVisual.getPistonOffset(time + 12.0f), 0.0f);
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.piston1, this.piston2, this.piston3, this.piston4, this.piston5, this.piston6});
    }

    public void remove() {
        super.remove();
        this.piston1.delete();
        this.piston2.delete();
        this.piston3.delete();
        this.piston4.delete();
        this.piston5.delete();
        this.piston6.delete();
    }

    public static float getPistonOffset(double time) {
        return (float)(Math.sin(time) * (double)0.05f);
    }
}

