/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.ice_box;

import com.lightning.northstar.block.tech.ice_box.FreezingRecipe;
import com.lightning.northstar.block.tech.ice_box.IceBoxBlock;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.NorthstarTemperature;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class IceBoxBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private static final Object FREEZING_RECIPES_KEY = new Object();
    public static final int OUTPUT_ANIMATION_TIME = 10;
    protected SmartInventory inputInventory = new SmartInventory(9, (SyncedBlockEntity)this, 16, true);
    protected SmartInventory outputInventory;
    protected SmartFluidTankBehaviour inputTank;
    protected SmartFluidTankBehaviour outputTank;
    protected FilteringBehaviour filtering;
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected boolean contentsChanged;
    protected Recipe<?> currentRecipe;
    protected int processingTicks;
    protected List<IntAttached<ItemStack>> visualizedOutputItems;
    protected List<IntAttached<FluidStack>> visualizedOutputFluids;

    public IceBoxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inputInventory.whenContentsChanged($ -> {
            this.contentsChanged = true;
        });
        this.outputInventory = new SmartInventory(9, (SyncedBlockEntity)this, 16, true).forbidInsertion().withMaxStackSize(64);
        this.contentsChanged = true;
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventory}));
        this.visualizedOutputFluids = Collections.synchronizedList(new ArrayList());
        this.visualizedOutputItems = Collections.synchronizedList(new ArrayList());
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new IceBoxValueBox()).withCallback($ -> {
            this.contentsChanged = true;
        }).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.inputTank.getCapability();
            LazyOptional outputCap = this.outputTank.getCapability();
            return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)outputCap.orElse(null), (IFluidHandler)inputCap.orElse(null)});
        });
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInventory);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInventory);
    }

    public void tick() {
        Recipe<?> recipe;
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.contentsChanged) {
            this.currentRecipe = this.getMatchingRecipe();
            this.contentsChanged = false;
        }
        if (!((recipe = this.currentRecipe) instanceof FreezingRecipe)) {
            return;
        }
        FreezingRecipe r = (FreezingRecipe)recipe;
        float currentTemperature = NorthstarTemperature.getTemperatureAt(this.f_58857_, (Vec3i)this.f_58858_);
        if (!r.isTemperatureWithinRange(currentTemperature)) {
            this.processingTicks = Math.max(0, this.processingTicks - 1);
            return;
        }
        if (++this.processingTicks >= r.getProcessingDuration() && FreezingRecipe.apply(this, r)) {
            this.processingTicks = 0;
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
        }
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        this.outputInventory.allowInsertion();
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, outputFluids, simulate);
        this.outputInventory.forbidInsertion();
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof IceBoxBlock)) {
            return false;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)IceBoxBlock.FACING);
        if (direction != Direction.DOWN) {
            boolean externalTankNotPresent;
            InvManipulationBehaviour inserter;
            BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_7495_().m_121945_(direction));
            InvManipulationBehaviour invManipulationBehaviour = inserter = be == null ? null : (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)be.m_58899_(), (BehaviourType)InvManipulationBehaviour.TYPE);
            IItemHandler targetInv = be == null ? null : (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory());
            IFluidHandler targetTank = be == null ? null : (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).orElse(null);
            boolean bl = externalTankNotPresent = targetTank == null;
            if (!outputItems.isEmpty() && targetInv == null) {
                return false;
            }
            if (!outputFluids.isEmpty() && externalTankNotPresent) {
                targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
                if (targetTank == null) {
                    return false;
                }
                if (!this.acceptFluidOutputsIntoIceBox(outputFluids, simulate, targetTank)) {
                    return false;
                }
            }
            if (simulate) {
                return true;
            }
        }
        SmartInventory targetInv = this.outputInventory;
        IFluidHandler targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
        if (targetInv == null && !outputItems.isEmpty()) {
            return false;
        }
        if (!this.acceptItemOutputsIntoIceBox(outputItems, simulate, (IItemHandler)targetInv)) {
            return false;
        }
        if (outputFluids.isEmpty()) {
            return true;
        }
        if (targetTank == null) {
            return false;
        }
        return this.acceptFluidOutputsIntoIceBox(outputFluids, simulate, targetTank);
    }

    private boolean acceptFluidOutputsIntoIceBox(List<FluidStack> outputFluids, boolean simulate, IFluidHandler targetTank) {
        for (FluidStack fluidStack : outputFluids) {
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
            if (fill == fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    private boolean acceptItemOutputsIntoIceBox(List<ItemStack> outputItems, boolean simulate, IItemHandler targetInv) {
        for (ItemStack itemStack : outputItems) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)simulate).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public float getTotalFluidUnits(float partialTicks) {
        float units;
        int renderedFluids = 0;
        float totalUnits = 0.0f;
        for (SmartFluidTankBehaviour.TankSegment tankSegment : this.inputTank.getTanks()) {
            if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
            totalUnits += units;
            ++renderedFluids;
        }
        for (SmartFluidTankBehaviour.TankSegment tankSegment : this.outputTank.getTanks()) {
            if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
            totalUnits += units;
            ++renderedFluids;
        }
        if (renderedFluids == 0) {
            return 0.0f;
        }
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        return totalUnits;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean isEmpty() {
        return this.inputInventory.m_7983_() && this.inputTank.isEmpty() && this.outputInventory.m_7983_() && this.outputTank.isEmpty();
    }

    public SmartInventory getInputInventory() {
        return this.inputInventory;
    }

    protected Recipe<?> getMatchingRecipe() {
        if (this.isEmpty()) {
            return null;
        }
        return RecipeFinder.get((Object)FREEZING_RECIPES_KEY, (Level)this.f_58857_, this::matchStaticFilters).stream().filter(this::matchFreezingRecipe).min((r1, r2) -> r2.m_7527_().size() - r1.m_7527_().size()).orElse(null);
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == NorthstarRecipeTypes.FREEZING.getType();
    }

    protected <C extends Container> boolean matchFreezingRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        return FreezingRecipe.match(this, recipe);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inputInventory.deserializeNBT(compound.m_128469_("InputItems"));
        this.outputInventory.deserializeNBT(compound.m_128469_("OutputItems"));
        if (!clientPacket) {
            return;
        }
        NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("VisualizedItems", 10), c -> this.visualizedOutputItems.add((IntAttached<ItemStack>)IntAttached.with((int)10, (Object)ItemStack.m_41712_((CompoundTag)c))));
        NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("VisualizedFluids", 10), c -> this.visualizedOutputFluids.add((IntAttached<FluidStack>)IntAttached.with((int)10, (Object)FluidStack.loadFluidStackFromNBT((CompoundTag)c))));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("InputItems", (Tag)this.inputInventory.serializeNBT());
        compound.m_128365_("OutputItems", (Tag)this.outputInventory.serializeNBT());
        if (!clientPacket) {
            return;
        }
        compound.m_128365_("VisualizedItems", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputItems, ia -> ((ItemStack)ia.getValue()).serializeNBT()));
        compound.m_128365_("VisualizedFluids", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputFluids, ia -> ((FluidStack)ia.getValue()).writeToNBT(new CompoundTag())));
        this.visualizedOutputItems.clear();
        this.visualizedOutputFluids.clear();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        NorthstarLang.translate("gui.goggles.ice_box_contents", new Object[0]).forGoggles(tooltip);
        IItemHandlerModifiable items = (IItemHandlerModifiable)this.itemCapability.orElse((Object)new ItemStackHandler());
        IFluidHandler fluids = (IFluidHandler)this.fluidCapability.orElse(null);
        boolean isEmpty = true;
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            Lang.text((String)"").add(Component.m_237115_((String)stackInSlot.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(Lang.text((String)(" x" + stackInSlot.m_41613_())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        for (int b = 0; b < fluids.getTanks(); ++b) {
            FluidStack stackInSlot = fluids.getFluidInTank(b);
            if (stackInSlot.isEmpty()) continue;
            if (!stackInSlot.getFluid().getFluidType().isAir()) {
                Lang.fluidName((FluidStack)stackInSlot).style(ChatFormatting.GRAY).forGoggles(tooltip);
                Lang.builder().add(Lang.number((double)stackInSlot.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)fluids.getTankCapacity(b)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            }
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }

    private static class IceBoxValueBox
    extends ValueBoxTransform.Sided {
        private IceBoxValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)12.0, (double)16.05);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.m_122434_().m_122479_();
        }
    }
}

