/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.contraption;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.MutablePair;

public class ActorConfigPacket
extends SimplePacketBase {
    private final int contraptionId;
    private final BlockPos localPos;
    private final CompoundTag nbt;

    public ActorConfigPacket(FriendlyByteBuf buffer) {
        this.contraptionId = buffer.m_130242_();
        this.localPos = buffer.m_130135_();
        this.nbt = buffer.m_130260_();
    }

    public ActorConfigPacket(int contraptionId, BlockPos localPos, CompoundTag nbt) {
        this.contraptionId = contraptionId;
        this.localPos = localPos;
        this.nbt = nbt;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.contraptionId);
        buffer.m_130064_(this.localPos);
        buffer.m_130079_(this.nbt);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            MutablePair actor;
            Entity patt1632$temp = Minecraft.m_91087_().f_91073_.m_6815_(this.contraptionId);
            if (!(patt1632$temp instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity entity = (AbstractContraptionEntity)patt1632$temp;
            Contraption contraption = entity.getContraption();
            StructureTemplate.StructureBlockInfo block = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(this.localPos);
            if (block != null) {
                contraption.getBlocks().put(this.localPos, new StructureTemplate.StructureBlockInfo(block.f_74675_(), block.f_74676_(), this.nbt));
            }
            if ((actor = contraption.getActorAt(this.localPos)) == null) {
                return;
            }
            Object patt2258$temp = ((MovementContext)actor.right).temporaryData;
            if (patt2258$temp instanceof ITakeConfig) {
                ITakeConfig config = (ITakeConfig)patt2258$temp;
                config.handleServerConfig(this.nbt);
            }
        });
        return true;
    }

    public static interface ITakeConfig {
        public void handleServerConfig(CompoundTag var1);
    }
}

