/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.entity.MarsToadEntity;
import com.lightning.northstar.entity.MarsWormAi;
import com.lightning.northstar.entity.goals.LayEggInNestGoal;
import java.util.Collections;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MarsWormEntity
extends Monster
implements GeoAnimatable,
VibrationSystem {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.2, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Integer> CLIENT_ANGER_LEVEL = SynchedEntityData.m_135353_(MarsWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener;
    private final VibrationSystem.User vibrationUser;
    private VibrationSystem.Data vibrationData;
    private boolean aggro;
    private int angerTimer = 0;
    public int eggTimer = 0;
    private LivingEntity notTarget;
    private UUID notTargetUUID;
    private int attackTick;
    private AngerManagement angerManagement = new AngerManagement(this::canTargetEntity, Collections.emptyList());

    public MarsWormEntity(EntityType<? extends MarsWormEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
        this.dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
        this.vibrationUser = new VibrationUser();
        this.vibrationData = new VibrationSystem.Data();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    private PlayState predicate(AnimationState<MarsWormEntity> event) {
        AnimationController controller = event.getController();
        if (this.attackTick > 0) {
            --this.attackTick;
            controller.setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().then("bite", Animation.LoopType.PLAY_ONCE));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            controller.setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else {
            controller.setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    @NotNull
    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    @NotNull
    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.attackTick = 40;
        } else {
            super.m_7822_(pId);
        }
    }

    public static boolean wormSpawnRules(EntityType<MarsWormEntity> cobra, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
        BlockState state = level.m_8055_(pos.m_7495_());
        if (pos.m_123342_() >= surfaceY) {
            return false;
        }
        if ((double)pos.m_123342_() < (double)surfaceY / 2.5) {
            int light = level.m_46803_(pos);
            return light != 0 ? false : MarsWormEntity.m_217057_(cobra, (LevelAccessor)level, (MobSpawnType)spawntype, (BlockPos)pos, (RandomSource)rando) && state.m_204336_(NorthstarTags.NorthstarBlockTags.NATURAL_MARS_BLOCKS.tag);
        }
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIENT_ANGER_LEVEL, (Object)0);
    }

    public int getClientAngerLevel() {
        return (Integer)this.f_19804_.m_135370_(CLIENT_ANGER_LEVEL);
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> pListenerConsumer) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            pListenerConsumer.accept(this.dynamicGameEventListener, serverlevel);
        }
    }

    private void syncClientAngerLevel() {
        this.f_19804_.m_135381_(CLIENT_ANGER_LEVEL, (Object)this.getActiveAnger());
    }

    private int getActiveAnger() {
        return this.angerManagement.m_219286_((Entity)this.m_5448_());
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        if (this.eggTimer > 0) {
            --this.eggTimer;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (this.notTargetUUID != null) {
                this.notTarget = (LivingEntity)serverlevel.m_8791_(this.notTargetUUID);
                this.notTargetUUID = null;
            }
            VibrationSystem.Ticker.m_280259_((Level)serverlevel, (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
            if (this.m_5448_() != null && this.angerTimer > 0 && (double)this.m_5448_().m_20270_((Entity)this) > this.m_21133_(Attributes.f_22277_)) {
                --this.angerTimer;
            }
            if (this.m_5448_() != null) {
                Player plyr;
                LivingEntity livingEntity;
                if (this.m_5448_().m_5833_()) {
                    this.m_6710_(null);
                    this.notTarget = null;
                }
                if ((livingEntity = this.m_5448_()) instanceof Player && (plyr = (Player)livingEntity).m_7500_()) {
                    this.m_6710_(null);
                    this.notTarget = null;
                }
            }
            if (this.f_19797_ % 40 == 0) {
                // empty if block
            }
            if (this.angerTimer <= 0) {
                this.m_6710_(null);
                this.notTarget = null;
                this.aggro = false;
            }
            for (Entity ent : level.m_45933_((Entity)this, this.m_20191_())) {
                LivingEntity lEnt;
                if (!(ent instanceof LivingEntity) || !this.canTargetEntity((Entity)(lEnt = (LivingEntity)ent))) continue;
                this.notTarget = lEnt;
                this.aggro = true;
            }
            if (this.notTarget != null) {
                if (this.m_20270_((Entity)this.notTarget) < 2.0f) {
                    this.aggro = true;
                }
                if (this.notTarget.m_21223_() <= 0.0f) {
                    this.notTarget = null;
                    this.m_6710_(null);
                    this.aggro = false;
                }
            }
            if (this.aggro && this.notTarget != null) {
                this.m_6710_(this.notTarget);
            } else {
                this.m_6710_(null);
                this.aggro = false;
            }
            if (this.aggro && this.m_5448_() == null) {
                this.aggro = false;
            }
        }
        super.m_8119_();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("aggro", this.aggro);
        if (this.notTarget != null) {
            pCompound.m_128362_("notTarget", this.notTarget.m_20148_());
        }
        pCompound.m_128405_("eggTimer", this.eggTimer);
        pCompound.m_128405_("angerTimer", this.angerTimer);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("aggro")) {
            this.aggro = pCompound.m_128471_("aggro");
        }
        if (pCompound.m_128441_("notTarget")) {
            this.notTargetUUID = pCompound.m_128342_("notTarget");
        }
        this.eggTimer = pCompound.m_128451_("eggTimer");
        this.angerTimer = pCompound.m_128451_("angerTimer");
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        boolean flag = super.m_6469_(pSource, pAmount);
        if (!this.m_9236_().f_46443_ && !this.m_21525_() && (entity = pSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.canTargetEntity(entity) && this.notTarget == null) {
                this.notTarget = living;
                this.aggro = true;
            }
        }
        return flag;
    }

    protected void m_8024_() {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_5448_() != null) {
            if (!attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        } else if (attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
            attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        }
        super.m_8024_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LayEggInNestGoal(this, 1.0, 10));
        super.m_8099_();
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return (SoundEvent)NorthstarSounds.MARS_WORM_CLICK.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        super.m_7975_(pDamageSource);
        return (SoundEvent)NorthstarSounds.MARS_WORM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        super.m_5592_();
        return (SoundEvent)NorthstarSounds.MARS_WORM_DEATH.get();
    }

    public boolean m_7327_(Entity pEntity) {
        LivingEntity liv;
        boolean flag = super.m_7327_(pEntity);
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_((SoundEvent)NorthstarSounds.MARS_WORM_ATTACK.get(), 1.0f, 1.0f);
        if (pEntity instanceof LivingEntity && (liv = (LivingEntity)pEntity).m_21223_() <= 0.0f) {
            this.m_6710_(null);
            this.aggro = false;
            this.notTarget = null;
        }
        return flag;
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable Entity ent) {
        if (ent instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)ent;
            if (this.m_9236_() == ent.m_9236_() && (ent instanceof Player || ent instanceof ZombifiedPiglin || ent instanceof MarsToadEntity)) {
                Player player;
                if (ent instanceof Player && (player = (Player)ent).m_7500_()) {
                    return false;
                }
                if (ent.m_5833_()) {
                    return false;
                }
                if (this.notTarget == null) {
                    this.notTarget = livingentity;
                    this.angerTimer = 2400;
                }
                return true;
            }
        }
        return false;
    }

    private class VibrationUser
    implements VibrationSystem.User {
        private VibrationUser() {
        }

        public int m_280351_() {
            return 16;
        }

        @NotNull
        public PositionSource m_280010_() {
            return new EntityPositionSource((Entity)MarsWormEntity.this, MarsWormEntity.this.m_20192_());
        }

        public boolean m_280080_(ServerLevel level, BlockPos pos, GameEvent event, GameEvent.Context context) {
            if (!(MarsWormEntity.this.m_21525_() || MarsWormEntity.this.m_21224_() || MarsWormEntity.this.m_6274_().m_21874_(MemoryModuleType.f_217774_) || !level.m_6857_().m_61937_(pos) || MarsWormEntity.this.m_213877_() || MarsWormEntity.this.m_9236_() != level)) {
                Entity entity = context.f_223711_();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entity;
                    return MarsWormEntity.this.canTargetEntity((Entity)livingentity);
                }
                return true;
            }
            return false;
        }

        public void m_280271_(ServerLevel level, BlockPos pos, GameEvent event, @Nullable Entity entity, @Nullable Entity player, float distance) {
            if (!MarsWormEntity.this.m_21224_()) {
                MarsWormEntity.this.f_20939_.m_21882_(MemoryModuleType.f_217774_, (Object)Unit.INSTANCE, 40L);
                level.m_7605_((Entity)MarsWormEntity.this, (byte)61);
                if (!MarsWormEntity.this.aggro) {
                    MarsWormEntity.this.m_5496_((SoundEvent)NorthstarSounds.MARS_WORM_CLICK_NOTICE.get(), 5.0f, MarsWormEntity.this.m_6100_());
                }
                MarsWormAi.setDisturbanceLocation(MarsWormEntity.this, pos);
                if (!(MarsWormEntity.this.notTarget == null || MarsWormEntity.this.aggro || MarsWormEntity.this.notTarget != entity && MarsWormEntity.this.notTarget != player)) {
                    MarsWormEntity.this.aggro = true;
                }
            }
        }
    }
}

