/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.block;

import com.lightning.northstar.world.NorthstarTemperature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FluidState.class})
public class FluidStateMixin {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void northstar$tick(Level pLevel, BlockPos pPos, CallbackInfo info) {
        FluidState state = pLevel.m_6425_(pPos);
        BlockState block = pLevel.m_8055_(pPos);
        float temp = NorthstarTemperature.getTemperatureAt(pLevel, (Vec3i)pPos);
        if (temp > (float)NorthstarTemperature.getBoilingPoint(state)) {
            if (block.m_61138_((Property)BlockStateProperties.f_61362_) && !state.m_76178_()) {
                pLevel.m_46597_(pPos, (BlockState)block.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                this.removeFluid(pLevel, pPos, state);
            } else {
                pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
                this.removeFluid(pLevel, pPos, state);
            }
        }
        if (temp < (float)NorthstarTemperature.getFreezingPoint(state) && state.m_192917_((Fluid)Fluids.f_76193_)) {
            if (block.m_61138_((Property)BlockStateProperties.f_61362_)) {
                pLevel.m_46597_(pPos, (BlockState)block.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                this.removeFluid(pLevel, pPos, state);
            } else {
                pLevel.m_46597_(pPos, Blocks.f_50126_.m_49966_());
            }
        }
        if (NorthstarTemperature.isCombustible(state) && (float)NorthstarTemperature.combustionTemp(state) <= temp) {
            this.combust(pLevel, pPos, state);
        }
    }

    public void removeFluid(Level level, BlockPos pos, FluidState fluid) {
        for (Direction dir : Direction.values()) {
            BlockPos.MutableBlockPos newpos = pos.m_122032_().m_122173_(dir);
            if (level.m_6425_((BlockPos)newpos).m_192917_(fluid.m_76152_()) && level.m_8055_((BlockPos)newpos).m_60722_(fluid.m_76152_()) && !level.m_8055_((BlockPos)newpos).m_61138_((Property)BlockStateProperties.f_61362_)) {
                level.m_7731_((BlockPos)newpos, Blocks.f_50016_.m_49966_(), 3);
                continue;
            }
            if (!level.m_8055_((BlockPos)newpos).m_61138_((Property)BlockStateProperties.f_61362_) || !fluid.m_192917_((Fluid)Fluids.f_76193_)) continue;
            level.m_46597_((BlockPos)newpos, (BlockState)level.m_8055_((BlockPos)newpos).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void combust(Level level, BlockPos pos, FluidState fluid) {
        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        level.m_255391_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2.5f, true, Level.ExplosionInteraction.MOB);
    }
}

