/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.block;

import com.lightning.northstar.particle.ColdAirParticleData;
import com.lightning.northstar.world.NorthstarTemperature;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IceBlock.class})
public class IceBlockMixin {
    @Inject(method={"randomTick"}, at={@At(value="TAIL")})
    public void northstar$randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo info) {
        if (!state.m_60713_(Blocks.f_50126_)) {
            return;
        }
        float temperature = this.northstar$getHighestTemperatureAround(level, pos);
        if ((double)random.m_188501_() > 0.4) {
            if (100.0f < temperature) {
                this.northstar$evaporate((Level)level, pos);
            } else if (32.0f < temperature) {
                this.northstar$melt((Level)level, pos);
            }
        } else if (32.0f < temperature) {
            this.northstar$coldAirParticles((Level)level, pos, random);
        }
    }

    @Unique
    public float northstar$getHighestTemperatureAround(ServerLevel level, BlockPos pos) {
        float temperature = Float.NEGATIVE_INFINITY;
        for (Direction direction : Iterate.directions) {
            float temp = NorthstarTemperature.getTemperatureAt((Level)level, (Vec3i)pos.m_121945_(direction));
            if (!(temp > temperature)) continue;
            temperature = temp;
        }
        return temperature;
    }

    @Unique
    public void northstar$coldAirParticles(Level level, BlockPos pos, RandomSource random) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        for (Direction dir : Direction.values()) {
            if (!level.m_8055_(pos.m_121945_(dir)).m_60795_() || random.m_188503_(20) != 0) continue;
            double d0 = (double)x + (double)(dir.m_122429_() / 2) + random.m_188500_();
            double d1 = (double)y + 0.7;
            double d2 = (double)z + (double)(dir.m_122431_() / 2) + random.m_188500_();
            level.m_7106_((ParticleOptions)new ColdAirParticleData(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Unique
    protected void northstar$melt(Level pLevel, BlockPos pPos) {
        pLevel.m_46597_(pPos, Fluids.f_76193_.getFluidType().getBlockForFluidState((BlockAndTintGetter)pLevel, pPos, Fluids.f_76193_.m_76145_()));
        pLevel.m_46586_(pPos, Fluids.f_76193_.getFluidType().getBlockForFluidState((BlockAndTintGetter)pLevel, pPos, Fluids.f_76193_.m_76145_()).m_60734_(), pPos);
    }

    @Unique
    protected void northstar$evaporate(Level level, BlockPos pos) {
        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        level.m_46586_(pos, Blocks.f_50016_, pos);
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

