/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world;

import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="northstar", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WeatherStuff {
    public static Map<Pair<Pair<Direction, Direction>, Pair<WeatherCondition, Integer>>, ResourceKey<Level>> managedPlanets = new HashMap<Pair<Pair<Direction, Direction>, Pair<WeatherCondition, Integer>>, ResourceKey<Level>>();

    public static void init() {
        managedPlanets.put(null, NorthstarDimensions.MARS_DIM_KEY);
        managedPlanets.put(null, NorthstarDimensions.VENUS_DIM_KEY);
    }

    public Pair<Direction, Direction> getWindDirection(ResourceKey<Level> lev) {
        if (managedPlanets.containsValue(lev)) {
            for (Map.Entry<Pair<Pair<Direction, Direction>, Pair<WeatherCondition, Integer>>, ResourceKey<Level>> entries : managedPlanets.entrySet()) {
                if (entries.getValue() != lev) continue;
                return (Pair)entries.getKey().getFirst();
            }
        }
        return null;
    }

    public WeatherCondition getWeatherConditions(ResourceKey<Level> lev) {
        if (managedPlanets.containsValue(lev)) {
            for (Map.Entry<Pair<Pair<Direction, Direction>, Pair<WeatherCondition, Integer>>, ResourceKey<Level>> entries : managedPlanets.entrySet()) {
                if (entries.getValue() != lev) continue;
                return (WeatherCondition)((Object)((Pair)entries.getKey().getSecond()).getFirst());
            }
        }
        return WeatherCondition.CLEAR;
    }

    public static boolean hasWind(ResourceKey<Level> lev) {
        return lev == NorthstarDimensions.MARS_DIM_KEY;
    }

    public static boolean hasWeather(ResourceKey<Level> lev) {
        if (lev == NorthstarDimensions.MARS_DIM_KEY) {
            return true;
        }
        return lev == NorthstarDimensions.VENUS_DIM_KEY;
    }

    public static enum WeatherCondition {
        CLEAR,
        RAINY,
        STORMY;

    }
}

