/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features.configuration;

import com.google.common.collect.ImmutableList;
import com.lightning.northstar.world.features.trunkplacers.ArgyreTrunkPlacer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public record AlienTreeConfig(BlockStateProvider trunkProvider, BlockStateProvider glowProvider, ArgyreTrunkPlacer trunkPlacer, BlockStateProvider foliageProvider, FoliagePlacer foliagePlacer, Optional<RootPlacer> rootPlacer, BlockStateProvider dirtProvider, FeatureSize minimumSize, List<TreeDecorator> decorators, boolean ignoreVines, boolean forceDirt) implements FeatureConfiguration
{
    public static final Codec<AlienTreeConfig> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockStateProvider.f_68747_.fieldOf("trunk_provider").forGetter(AlienTreeConfig::trunkProvider), (App)BlockStateProvider.f_68747_.fieldOf("glow_provider").forGetter(AlienTreeConfig::glowProvider), (App)ArgyreTrunkPlacer.CODEC.fieldOf("trunk_placer").forGetter(AlienTreeConfig::trunkPlacer), (App)BlockStateProvider.f_68747_.fieldOf("foliage_provider").forGetter(AlienTreeConfig::foliageProvider), (App)FoliagePlacer.f_68519_.fieldOf("foliage_placer").forGetter(AlienTreeConfig::foliagePlacer), (App)RootPlacer.f_225859_.optionalFieldOf("root_placer").forGetter(AlienTreeConfig::rootPlacer), (App)BlockStateProvider.f_68747_.fieldOf("dirt_provider").forGetter(AlienTreeConfig::dirtProvider), (App)FeatureSize.f_68281_.fieldOf("minimum_size").forGetter(AlienTreeConfig::minimumSize), (App)TreeDecorator.f_70021_.listOf().fieldOf("decorators").forGetter(AlienTreeConfig::decorators), (App)Codec.BOOL.fieldOf("ignore_vines").orElse((Object)false).forGetter(AlienTreeConfig::ignoreVines), (App)Codec.BOOL.fieldOf("force_dirt").orElse((Object)false).forGetter(AlienTreeConfig::forceDirt)).apply((Applicative)i, AlienTreeConfig::new));

    public static class AlienTreeConfigBuilder {
        public final BlockStateProvider trunkProvider;
        public final BlockStateProvider glowProvider;
        private final ArgyreTrunkPlacer trunkPlacer;
        public final BlockStateProvider foliageProvider;
        private final FoliagePlacer foliagePlacer;
        private final Optional<RootPlacer> rootPlacer;
        private BlockStateProvider dirtProvider;
        private final FeatureSize minimumSize;
        private List<TreeDecorator> decorators = ImmutableList.of();
        private boolean ignoreVines;
        private boolean forceDirt;

        public AlienTreeConfigBuilder(BlockStateProvider pTrunkProvider, BlockStateProvider glow, ArgyreTrunkPlacer pTrunkPlacer, BlockStateProvider pFoliageProvider, FoliagePlacer pFoliagePlacer, Optional<RootPlacer> pRootPlacer, FeatureSize pMinimumSize) {
            this.trunkProvider = pTrunkProvider;
            this.glowProvider = glow;
            this.trunkPlacer = pTrunkPlacer;
            this.foliageProvider = pFoliageProvider;
            this.dirtProvider = BlockStateProvider.m_191382_((Block)Blocks.f_50493_);
            this.foliagePlacer = pFoliagePlacer;
            this.rootPlacer = pRootPlacer;
            this.minimumSize = pMinimumSize;
        }

        public AlienTreeConfigBuilder(BlockStateProvider pTrunkProvider, BlockStateProvider glow, ArgyreTrunkPlacer pTrunkPlacer, BlockStateProvider pFoliageProvider, FoliagePlacer pFoliagePlacer, FeatureSize pMinimumSize) {
            this(pTrunkProvider, glow, pTrunkPlacer, pFoliageProvider, pFoliagePlacer, Optional.empty(), pMinimumSize);
        }

        public AlienTreeConfigBuilder dirt(BlockStateProvider pDirtProvider) {
            this.dirtProvider = pDirtProvider;
            return this;
        }

        public AlienTreeConfigBuilder decorators(List<TreeDecorator> pDecorators) {
            this.decorators = pDecorators;
            return this;
        }

        public AlienTreeConfigBuilder ignoreVines() {
            this.ignoreVines = true;
            return this;
        }

        public AlienTreeConfigBuilder forceDirt() {
            this.forceDirt = true;
            return this;
        }

        public AlienTreeConfig build() {
            return new AlienTreeConfig(this.trunkProvider, this.glowProvider, this.trunkPlacer, this.foliageProvider, this.foliagePlacer, this.rootPlacer, this.dirtProvider, this.minimumSize, this.decorators, this.ignoreVines, this.forceDirt);
        }
    }
}

