/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.advancements;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.lightning.northstar.advancements.NorthstarAdvancement;
import com.lightning.northstar.block.tech.telescope.TelescopeBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ColoredFallingBlock;

public class NorthstarAdvancements
implements DataProvider {
    public static final List<NorthstarAdvancement> ENTRIES = new ArrayList<NorthstarAdvancement>();
    public static final NorthstarAdvancement $ = null;
    public static final NorthstarAdvancement ROOT = NorthstarAdvancements.create("root", b -> b.icon((ItemLike)((TelescopeBlock)((Object)((Object)NorthstarBlocks.TELESCOPE.get()))).asItem()).title("Welcome to Northstar!").description("Shoot for the stars!").awardedForFree().special(NorthstarAdvancement.TaskType.SILENT));
    public static final NorthstarAdvancement ONE_SMALL_STEP = NorthstarAdvancements.create("one_small_step", b -> b.icon((ItemLike)((ColoredFallingBlock)NorthstarBlocks.MOON_SAND.get()).asItem()).title("One Small Step").description("Set foot on the moon").after(ROOT));
    public static final NorthstarAdvancement ONE_GIANT_LEAP = NorthstarAdvancements.create("one_giant_leap", b -> b.icon((ItemLike)((ColoredFallingBlock)NorthstarBlocks.MARS_SAND.get()).asItem()).title("One Giant Leap").description("Set foot on Mars").after(ONE_SMALL_STEP));
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    private static NorthstarAdvancement create(String id, UnaryOperator<NorthstarAdvancement.Builder> b) {
        return new NorthstarAdvancement(id, b);
    }

    public NorthstarAdvancements(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.output = output;
        this.registries = registries;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(provider -> {
            PackOutput.PathProvider pathProvider = this.output.createPathProvider(PackOutput.Target.DATA_PACK, "advancement");
            ArrayList futures = new ArrayList();
            HashSet set = Sets.newHashSet();
            Consumer<AdvancementHolder> consumer = advancement -> {
                ResourceLocation id = advancement.id();
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate advancement " + String.valueOf(id));
                }
                Path path = pathProvider.json(id);
                LOGGER.info("Saving advancement {}", (Object)id);
                futures.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)provider, (Codec)Advancement.CODEC, (Object)advancement.value(), (Path)path));
            };
            for (NorthstarAdvancement advancement2 : ENTRIES) {
                advancement2.save(consumer, (HolderLookup.Provider)provider);
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "Northstar's Advancements";
    }

    public static JsonObject provideLangEntries() {
        JsonObject object = new JsonObject();
        for (NorthstarAdvancement advancement : ENTRIES) {
            advancement.appendToLang(object);
        }
        return object;
    }

    public static void register() {
    }
}

