/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.api.data.recipe;

import com.google.common.base.Supplier;
import com.lightning.northstar.Northstar;
import com.lightning.northstar.data.Tags;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;

public abstract class StandardRecipeGen
extends BaseRecipeProvider {
    public void createMaterial(ItemLike nuggets, ItemLike ingot, ItemLike block) {
        if (nuggets != null) {
            this.create((Supplier<? extends ItemLike>)((Supplier)() -> nuggets)).returns(9).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ingot)).withSuffix("_from_ingot").viaShapeless(b -> b.requires(ingot));
            this.create((Supplier<? extends ItemLike>)((Supplier)() -> ingot)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> nuggets)).withSuffix("_from_nuggets").viaShapeless(b -> b.requires(nuggets, 9));
        }
        if (block != null) {
            this.create((Supplier<? extends ItemLike>)((Supplier)() -> ingot)).returns(9).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> block)).withSuffix("_from_block").viaShapeless(b -> b.requires(block));
            this.create((Supplier<? extends ItemLike>)((Supplier)() -> block)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ingot)).withSuffix("_from_ingot").viaShapeless(b -> b.requires(ingot, 9));
        }
    }

    public void interchangeable(ItemLike item1, ItemLike item2) {
        this.create((Supplier<? extends ItemLike>)((Supplier)() -> item1)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> item2)).withSuffix("_from_" + RegisteredObjectsHelper.getKeyOrThrow((Item)item2.asItem()).getPath()).viaShapeless(b -> b.requires(item2));
        this.create((Supplier<? extends ItemLike>)((Supplier)() -> item2)).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> item1)).withSuffix("_from_" + RegisteredObjectsHelper.getKeyOrThrow((Item)item1.asItem()).getPath()).viaShapeless(b -> b.requires(item1));
    }

    public void createOre(Supplier<TagKey<Item>> ore, Supplier<? extends ItemLike> ingot, float xp, int smeltDuration) {
        this.create(ingot).unlockedByTag(ore).viaCookingTag(ore).rewardXP(xp).forDuration(smeltDuration).inBlastFurnace();
    }

    protected Builder create(Supplier<? extends ItemLike> result) {
        return new Builder(result);
    }

    protected Builder create(ItemProviderEntry<? extends ItemLike, ? extends ItemLike> result) {
        return this.create((Supplier<? extends ItemLike>)((Supplier)() -> result.get()));
    }

    public StandardRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String defaultNamespace) {
        super(output, registries, defaultNamespace);
    }

    public class Builder {
        private Supplier<? extends ItemLike> result;
        private int amount;
        private String suffix;
        private List<ICondition> conditions;
        private Supplier<ItemPredicate> unlockedBy;

        public Builder(Supplier<? extends ItemLike> result) {
            this.result = result;
            this.amount = 1;
            this.suffix = "";
            this.conditions = new ArrayList<ICondition>();
            this.unlockedBy = null;
        }

        public Builder returns(int amount) {
            this.amount = amount;
            return this;
        }

        public Builder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)item.get()}).build();
            return this;
        }

        public Builder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of((TagKey)tag.get()).build();
            return this;
        }

        public Builder whenModLoaded(Tags.Mod mod) {
            return this.whenModLoaded(mod.getModId());
        }

        public Builder whenModLoaded(String modId) {
            return this.withCondition((ICondition)new ModLoadedCondition(modId));
        }

        public Builder whenModMissing(Tags.Mod mod) {
            return this.whenModMissing(mod.getModId());
        }

        public Builder whenModMissing(String modId) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modId)));
        }

        public Builder withCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public BaseRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return StandardRecipeGen.this.register(recipe -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", StandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.save(recipe.withConditions(this.conditions.toArray(new ICondition[0])), this.createLocation("crafting"));
            });
        }

        public BaseRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return StandardRecipeGen.this.register(recipe -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", StandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.save(recipe.withConditions(this.conditions.toArray(new ICondition[0])), this.createLocation("crafting"));
            });
        }

        public Cooking viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        public Cooking viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.of((TagKey)((TagKey)tag.get()))));
        }

        public Cooking viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new Cooking(ingredient);
        }

        private ResourceLocation createLocation(String recipeType) {
            return Northstar.asResource(recipeType + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return RegisteredObjectsHelper.getKeyOrThrow((Item)((ItemLike)this.result.get()).asItem());
        }

        public class Cooking {
            private Supplier<Ingredient> ingredient;
            private int duration;
            private float xp;

            private Cooking(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.duration = 200;
                this.xp = 0.0f;
            }

            public Cooking forDuration(int duration) {
                this.duration = duration;
                return this;
            }

            public Cooking rewardXP(float xp) {
                this.xp = xp;
                return this;
            }

            public BaseRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            public BaseRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
            }

            public BaseRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            public BaseRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                this.create(RecipeSerializer.CAMPFIRE_COOKING_RECIPE, builder, CampfireCookingRecipe::new, 3.0f);
                return this.create(RecipeSerializer.SMOKING_RECIPE, builder, SmokingRecipe::new, 0.5f);
            }

            public BaseRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            public BaseRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                return this.create(RecipeSerializer.BLASTING_RECIPE, builder, BlastingRecipe::new, 0.5f);
            }

            private <T extends AbstractCookingRecipe> BaseRecipeProvider.GeneratedRecipe create(RecipeSerializer<T> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, AbstractCookingRecipe.Factory<T> factory, float cookingTimeModifier) {
                return StandardRecipeGen.this.register(consumer -> {
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.generic((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Builder.this.result.get()), (float)this.xp, (int)((int)((float)this.duration * cookingTimeModifier)), (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory));
                    if (Builder.this.unlockedBy != null) {
                        b.unlockedBy("has_item", StandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)Builder.this.unlockedBy.get()}));
                    }
                    b.save(consumer, Builder.this.createLocation(RegisteredObjectsHelper.getKeyOrThrow((RecipeSerializer)serializer).getPath()));
                });
            }
        }
    }
}

